set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      NULL,
      '3004144',
      30.609078,
      0,
      0,
      1,
      NULL,
      2.330246,
      '10-19-1978',
      30.645229,
      NULL,
      NULL,
      NULL,
      1.609766,
      2.109461,
      1,
      1.863172,
      0,
      1.866611,
      1,
      1.815123,
      0,
      0.456729,
      2.774692,
      NULL,
      0,
      0,
      NULL,
      0.270870,
      7,
      1.691349,
      NULL,
      1.819604,
      NULL,
      1,
      1.858862,
      1,
      NULL,
      0,
      1.519718,
      1,
      NULL,
      NULL,
      1.834305,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.298549,
      0,
      1.361096,
      3,
      NULL,
      NULL,
      1,
      0.457450,
      0.563174,
      1.488345,
      NULL,
      0,
      3.523562,
      1,
      3,
      1.117170,
      0.072775,
      1,
      0,
      0,
      1,
      0,
      1.479645,
      NULL,
      NULL,
      0.894825,
      NULL,
      NULL,
      0,
      0.721762,
      5.107547,
      0.963346,
      2,
      1.353161,
      0,
      1.443068,
      0.804019,
      1.366561,
      NULL,
      0,
      NULL,
      1.095202,
      NULL,
      0.458871,
      1.452981,
      1.554229,
      NULL,
      NULL,
      0,
      1.671750,
      1.869331,
      2.081154,
      1.650784,
      NULL,
      NULL,
      0.011458,
      4,
      1.164867,
      NULL,
      4,
      0,
      0.687869,
      3.184972,
      NULL,
      1,
      1,
      4.662079,
      4,
      5.679605,
      NULL,
      NULL,
      2,
      NULL,
      3.954084,
      0,
      3,
      0.661239,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.275835,
      NULL,
      1,
      0.355126,
      2.718752,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173808,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      7,
      3.552327,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.117372,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.274830,
      0,
      1,
      2,
      2.477200,
      0,
      NULL,
      0.397046,
      2.298249,
      1.705933,
      0,
      1,
      1.431876,
      NULL,
      1,
      0,
      0,
      0.745525,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.365049,
      '34301',
      '',
      '',
      0.795285,
      '',
      NULL,
      '',
      1.988904,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


