set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '1302032',
      9.063519,
      6,
      0.328287,
      0,
      '233023',
      NULL,
      ' 2-25-1993',
      14.899798,
      NULL,
      0,
      NULL,
      0.120503,
      3.891587,
      0,
      1.902686,
      1,
      0.913605,
      1,
      1.183063,
      1,
      1,
      6.415920,
      1,
      0,
      NULL,
      3.412247,
      0,
      5,
      1.979289,
      1.531249,
      0.796257,
      NULL,
      1.523286,
      8.476248,
      0,
      0.002357,
      0,
      0.998034,
      NULL,
      NULL,
      NULL,
      1.468073,
      NULL,
      NULL,
      2.204645,
      1.617908,
      0.801869,
      0.762446,
      0,
      NULL,
      3.609810,
      3,
      NULL,
      1,
      1,
      NULL,
      1,
      0.959361,
      1,
      NULL,
      2,
      3,
      NULL,
      2,
      0,
      0.671320,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.535258,
      NULL,
      1,
      NULL,
      2,
      1.314609,
      1.876317,
      0.105473,
      1,
      NULL,
      0,
      0,
      0.093128,
      0.300819,
      NULL,
      1,
      1,
      1.640093,
      1.188365,
      NULL,
      0.446315,
      1,
      1,
      0,
      0.508587,
      0,
      5.773943,
      1,
      0,
      1,
      0.081968,
      4,
      4.426782,
      4.034464,
      2,
      NULL,
      2.077356,
      2.553321,
      5,
      3,
      7.340098,
      NULL,
      4.627519,
      6.727877,
      NULL,
      NULL,
      1,
      0.949511,
      3.670195,
      1.465118,
      1,
      0.949049,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.378547,
      NULL,
      1.579737,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.125323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374732,
      NULL,
      6,
      0.080875,
      2,
      2.901418,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.641558,
      3,
      1.875420,
      2.847579,
      1.183562,
      1.890282,
      0,
      0,
      NULL,
      1,
      1,
      0.344778,
      0.356482,
      NULL,
      1.766144,
      1,
      0,
      NULL,
      0.812465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.765893,
      '32344',
      '',
      NULL,
      0.766252,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


