set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '3143202',
      4,
      3,
      NULL,
      0,
      '041224',
      0,
      ' 3- 9-1990',
      52,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.351705,
      0.539743,
      1,
      0.914272,
      NULL,
      0.854531,
      0,
      0.938354,
      7.073091,
      0,
      1.582003,
      0.151596,
      1.037549,
      3,
      4.650820,
      NULL,
      4,
      4,
      1.586761,
      0,
      3.390488,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      1.159477,
      1.659068,
      0,
      NULL,
      0,
      2.350890,
      NULL,
      3,
      0,
      3,
      1.381514,
      3,
      1.220708,
      2,
      1.960685,
      0.435522,
      3.032263,
      4.859289,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.875896,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.959991,
      0,
      NULL,
      0,
      0.145794,
      0,
      1.512562,
      1,
      1,
      0.288813,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1.270784,
      1,
      0.593676,
      1,
      0,
      1.154436,
      1.358981,
      0.192765,
      NULL,
      1.066284,
      5.719342,
      1,
      NULL,
      0.640518,
      5.069023,
      NULL,
      4.059705,
      8.655002,
      2,
      4.522036,
      NULL,
      4,
      5,
      4.305672,
      NULL,
      0,
      1.216423,
      0.726201,
      2.413826,
      0,
      0,
      4,
      0.519916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.860265,
      NULL,
      3.578077,
      2,
      1.474701,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692769,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.676744,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111322,
      NULL,
      3.982232,
      0.615006,
      1.373329,
      0.498965,
      3,
      2.500443,
      1,
      0.731256,
      2,
      1.464373,
      NULL,
      1,
      1,
      NULL,
      1,
      0.020363,
      1.628542,
      0.098245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11400',
      '',
      NULL,
      0.738147,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


