set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      NULL,
      NULL,
      '1204212',
      25,
      5,
      NULL,
      0,
      '003122',
      1.501666,
      ' 6-15-1976',
      37.355803,
      NULL,
      NULL,
      NULL,
      0.226967,
      0,
      1,
      1.609060,
      NULL,
      1,
      1,
      1.736052,
      0.717686,
      0.265971,
      7,
      0.661526,
      NULL,
      0,
      1,
      0.727133,
      2,
      0,
      5.663334,
      5,
      0.159663,
      0.625465,
      NULL,
      0,
      1.291822,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.345369,
      NULL,
      NULL,
      1.572222,
      1,
      0.583547,
      1,
      0.225985,
      1,
      3,
      1.905203,
      3.375801,
      1.402101,
      NULL,
      0.920477,
      3.588052,
      0,
      3,
      NULL,
      1,
      1.797828,
      0,
      3.820049,
      3.984454,
      NULL,
      5,
      1,
      2,
      0.343786,
      0,
      NULL,
      NULL,
      0.986638,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.432067,
      5.447067,
      0.287371,
      4,
      0,
      0,
      1.434422,
      1.551653,
      0.591174,
      NULL,
      1.986715,
      0,
      0,
      1,
      1.783989,
      NULL,
      NULL,
      NULL,
      NULL,
      1.622239,
      0,
      NULL,
      NULL,
      6.173040,
      0.210696,
      1,
      0.009366,
      NULL,
      1.153957,
      0.050127,
      4,
      1,
      1,
      NULL,
      1.593952,
      3.587493,
      1.986586,
      6,
      NULL,
      6,
      NULL,
      5,
      3,
      1,
      1.366038,
      1.396092,
      0,
      NULL,
      6.156389,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.970211,
      0,
      1,
      0.282342,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      4,
      0.093857,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      0,
      3.652501,
      0.979678,
      NULL,
      NULL,
      NULL,
      1,
      1.263882,
      3.778795,
      NULL,
      3,
      0,
      2,
      1.660069,
      NULL,
      NULL,
      1.075939,
      4.587436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936737,
      1,
      1.284633,
      1.172540,
      2.352001,
      3,
      1.740859,
      0,
      1,
      2.668118,
      3,
      0,
      1.394413,
      NULL,
      0.648832,
      NULL,
      0,
      1,
      0.683392,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0.026090,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


