set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '0130422',
      NULL,
      2,
      0.887462,
      3,
      '240240',
      2,
      ' 7-24-2000',
      1.580339,
      NULL,
      0,
      NULL,
      2.662550,
      1,
      0.255867,
      0.422065,
      0,
      0,
      1,
      0,
      0,
      1.886684,
      1,
      0.548188,
      1.927430,
      2.482425,
      1.807877,
      1.593174,
      2,
      1.215284,
      4,
      4,
      0.193872,
      0,
      6,
      0,
      0.698752,
      0,
      1.845930,
      1.865263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.285374,
      0,
      0.325589,
      0,
      NULL,
      1.772465,
      0.846933,
      0.585682,
      2,
      1,
      1,
      0,
      3.722085,
      NULL,
      NULL,
      1,
      0,
      2.155230,
      2.543439,
      1.313722,
      2,
      0,
      0,
      0,
      1.702886,
      NULL,
      NULL,
      1.309841,
      NULL,
      NULL,
      0,
      0.474217,
      4,
      0,
      3,
      0.014690,
      NULL,
      1.550237,
      1,
      0,
      0.811991,
      1.188586,
      NULL,
      2.775291,
      1.794439,
      NULL,
      1.011518,
      NULL,
      NULL,
      NULL,
      1.348805,
      3.593897,
      1,
      1.875956,
      1,
      0.375804,
      4.758152,
      1,
      5.568908,
      NULL,
      2,
      NULL,
      1.054171,
      1,
      4.776071,
      1.864738,
      0,
      5.489978,
      0.222497,
      4,
      1.740597,
      3.605887,
      4.884715,
      2.654918,
      3.488765,
      3,
      NULL,
      5,
      0.810721,
      1,
      NULL,
      2.145076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405134,
      NULL,
      1,
      0.734873,
      1.761549,
      NULL,
      0.190103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      0.367721,
      NULL,
      0.388062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.127795,
      NULL,
      NULL,
      NULL,
      0.408507,
      1,
      1.914257,
      0.432000,
      2.318355,
      0,
      5.940050,
      1,
      NULL,
      NULL,
      1,
      3.518270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169412,
      0.789374,
      1.182014,
      1,
      2,
      1,
      1.517320,
      2,
      0.766938,
      0,
      0.870339,
      1.478573,
      1,
      NULL,
      1.281781,
      1,
      NULL,
      0.513962,
      NULL,
      0.511426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.753832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.225263,
      NULL,
      '',
      '',
      0.544238,
      '',
      '',
      '',
      1.594818,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


