set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-5-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      NULL,
      NULL,
      '2333130',
      22.418847,
      0,
      1.267146,
      NULL,
      NULL,
      3,
      ' 7-19-1983',
      4.690241,
      NULL,
      0.578058,
      NULL,
      0.968422,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.226208,
      0.437413,
      NULL,
      0,
      0.227491,
      1.508772,
      0.090969,
      0.779195,
      NULL,
      1,
      2,
      0,
      4,
      0.429210,
      1,
      0,
      NULL,
      0,
      1.951604,
      1,
      3,
      1,
      NULL,
      NULL,
      0.605596,
      NULL,
      NULL,
      5.397020,
      1.076812,
      1,
      NULL,
      0.924002,
      1.909564,
      NULL,
      NULL,
      3.863054,
      0,
      1.091212,
      2,
      NULL,
      2.128966,
      1,
      1.734606,
      NULL,
      0.547257,
      0,
      0.556213,
      2,
      1.204069,
      5,
      1,
      1,
      1.862555,
      1.287448,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.763448,
      3,
      0.347305,
      1,
      3,
      0,
      NULL,
      1.018772,
      0,
      0,
      0.941043,
      0.741831,
      1.823601,
      1,
      0.895231,
      0.193756,
      1,
      1.758532,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0.738587,
      4.010968,
      1.802908,
      0,
      NULL,
      4,
      5,
      0.321909,
      1.097987,
      2.848353,
      0,
      1.426579,
      2,
      0.120906,
      2,
      5.594391,
      5,
      6,
      3.299881,
      1,
      5,
      4.409707,
      2,
      0,
      0,
      0,
      0.816375,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590034,
      1.881309,
      0,
      1,
      1.392859,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739597,
      NULL,
      5.788270,
      2,
      0.686775,
      5.087547,
      0,
      3,
      1,
      1.905071,
      168,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      6.438811,
      5.696959,
      NULL,
      NULL,
      1.759413,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074500,
      2,
      1.342125,
      NULL,
      0,
      0.052045,
      1,
      0.214246,
      1,
      0,
      NULL,
      0.483747,
      0.705034,
      0.038234,
      1.824374,
      NULL,
      1.796739,
      1.927762,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.394215,
      '23013',
      '',
      '',
      0,
      '',
      '',
      '',
      0.817966,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


