set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      NULL,
      NULL,
      '1223222',
      35,
      NULL,
      1,
      1,
      '012024',
      3.680715,
      ' 3- 7-1989',
      23,
      NULL,
      1,
      NULL,
      0.152226,
      1,
      1.776638,
      1.456359,
      2,
      1,
      0,
      0,
      1.621361,
      0.543027,
      NULL,
      0.874267,
      1.415181,
      0,
      1.032265,
      1,
      1.918609,
      0.666740,
      4,
      NULL,
      NULL,
      NULL,
      7.809524,
      1,
      3,
      NULL,
      3.666704,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.999833,
      NULL,
      1,
      3.497361,
      1,
      0,
      NULL,
      0.274853,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.877494,
      1.731699,
      3.732007,
      0.076354,
      1.349408,
      1.155054,
      1,
      1,
      NULL,
      1.685393,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0.986664,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.928603,
      0.764266,
      1,
      0.129918,
      NULL,
      0,
      1,
      NULL,
      1,
      3.743308,
      1.466394,
      0.716447,
      0,
      NULL,
      3,
      NULL,
      5.935116,
      1,
      3,
      NULL,
      1.208842,
      1,
      2.273796,
      1,
      0,
      5.791173,
      NULL,
      1.572064,
      1,
      2,
      4.320820,
      3.631991,
      5,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.217577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184756,
      0.284402,
      0,
      0,
      0,
      0,
      1,
      1.345279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.117219,
      NULL,
      2,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.602979,
      0,
      5.357175,
      4,
      1.976971,
      1,
      0.900581,
      1.050672,
      NULL,
      NULL,
      0.805654,
      2,
      0.996389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576902,
      3,
      1.955599,
      1,
      0.287121,
      NULL,
      0.942188,
      NULL,
      NULL,
      1,
      1.034673,
      0.065773,
      1,
      0,
      0,
      1,
      0,
      1.766678,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '23412',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


