set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      NULL,
      NULL,
      '2021203',
      133,
      NULL,
      3,
      2,
      '244314',
      3.748934,
      '11-20-1989',
      57.744702,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      3,
      0,
      0,
      1,
      NULL,
      0.328403,
      0.381592,
      1.752200,
      3.608311,
      9.215958,
      9,
      3.253082,
      0,
      8,
      1,
      3,
      3,
      1.911937,
      NULL,
      0,
      1,
      NULL,
      1.139976,
      1,
      NULL,
      NULL,
      0.617733,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      2.789406,
      0.630084,
      1,
      1.942273,
      1.979035,
      0.374877,
      0.142378,
      NULL,
      NULL,
      3.278248,
      2.826359,
      0.422935,
      1.136944,
      3,
      1.711440,
      0,
      3.811668,
      2.478473,
      NULL,
      2,
      1,
      0,
      1.732427,
      1.656897,
      NULL,
      NULL,
      0.203067,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.347655,
      5,
      7,
      6,
      1,
      4.021302,
      6,
      4,
      NULL,
      0.928685,
      3.740379,
      0,
      NULL,
      1,
      1.184031,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      0,
      5.910644,
      1,
      2.677418,
      1.432301,
      1,
      2.024288,
      2.527116,
      NULL,
      3.307417,
      3.142039,
      2,
      1.256502,
      0.887691,
      7.971600,
      11.798845,
      5,
      NULL,
      9.299773,
      NULL,
      0.610237,
      NULL,
      1.240418,
      3.899994,
      1,
      NULL,
      4.183565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250140,
      0,
      1,
      1,
      3.465969,
      3.923085,
      1.321524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.675060,
      NULL,
      NULL,
      2.828576,
      0.012640,
      6,
      NULL,
      0.753375,
      1,
      1.190719,
      1,
      0.167855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.137118,
      NULL,
      11.863915,
      NULL,
      3.034235,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.906265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682523,
      1,
      3,
      0,
      0.102544,
      1,
      0,
      2,
      1,
      NULL,
      2,
      NULL,
      1,
      0.745429,
      1.722546,
      1,
      0,
      0,
      0,
      1.561249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.713948,
      '13032',
      '',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.211021,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


