set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      NULL,
      NULL,
      '2322312',
      36,
      NULL,
      0,
      1,
      NULL,
      1,
      ' 0-18-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.605194,
      1,
      1.068624,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.493907,
      0.023939,
      0,
      NULL,
      1.256860,
      2.156104,
      NULL,
      4.587479,
      NULL,
      3,
      2.758925,
      0,
      0.026271,
      6,
      1,
      1.740197,
      0.139804,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1.953424,
      1,
      1.255109,
      1,
      1.113397,
      0.089463,
      NULL,
      1,
      NULL,
      2.725965,
      1.648074,
      1,
      0.547027,
      0,
      NULL,
      0,
      1,
      1,
      2,
      1,
      2,
      0.009803,
      1,
      NULL,
      NULL,
      1.479652,
      NULL,
      NULL,
      0.808246,
      0,
      8,
      1,
      6.064642,
      2,
      1.611755,
      NULL,
      NULL,
      1.833040,
      0,
      NULL,
      1,
      3,
      1.713511,
      NULL,
      0.030353,
      0,
      1,
      NULL,
      1,
      5,
      2.262613,
      1,
      4.311111,
      0.857585,
      4,
      1,
      5.877720,
      0.032829,
      NULL,
      5.849144,
      0,
      0.687637,
      4.514384,
      NULL,
      5,
      9.976590,
      1,
      0.347861,
      2.725487,
      NULL,
      2,
      8,
      3,
      2.683363,
      2,
      6.742065,
      0,
      0.368505,
      0.446973,
      2.300611,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305243,
      NULL,
      NULL,
      NULL,
      1,
      0.080833,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.838984,
      1.071874,
      NULL,
      0.021188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.850847,
      2.515957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.663983,
      8.638500,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.352282,
      0.014163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      0.273940,
      0.552974,
      NULL,
      2.328980,
      NULL,
      0.803264,
      0.966918,
      0,
      1,
      0,
      1.817157,
      1.601294,
      0.458271,
      1,
      0.202567,
      0.028964,
      0.753584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


