set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '32',
      9,
      5,
      NULL,
      2,
      5,
      2.759242,
      2,
      '430024',
      0.575776,
      ' 4-24-2000',
      9.423197,
      3,
      NULL,
      NULL,
      0,
      1,
      1.469676,
      1.943089,
      1.695043,
      0,
      1,
      1.993346,
      NULL,
      1,
      9.381861,
      0.185128,
      1.649303,
      0.733303,
      1,
      1,
      2.825716,
      1,
      3.767847,
      0,
      0.691215,
      NULL,
      2.728392,
      0,
      0.028722,
      NULL,
      3.147114,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565494,
      1,
      1.488902,
      1,
      1.878049,
      1,
      2.640679,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649898,
      0.172124,
      NULL,
      NULL,
      0,
      1.120749,
      0,
      1,
      0.116677,
      0,
      5,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      6.098404,
      0,
      5,
      0.115408,
      0.160698,
      0,
      0.737401,
      3,
      0,
      2,
      1,
      0,
      1,
      1.237262,
      1.373213,
      NULL,
      0,
      4.142217,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.126356,
      3.530662,
      NULL,
      3,
      2,
      0,
      NULL,
      7,
      1,
      3,
      4,
      6,
      0.543162,
      4.473016,
      2,
      4.373579,
      3.203300,
      3.195924,
      3,
      2,
      2.957282,
      2.228084,
      0.443599,
      NULL,
      1.903303,
      0.774220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.174112,
      0.239575,
      0,
      1.320253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.191473,
      NULL,
      2,
      1.914146,
      NULL,
      0.218118,
      2,
      1.973261,
      0.431049,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      0.241048,
      2,
      7.418901,
      0,
      2,
      1.864359,
      NULL,
      NULL,
      0.554737,
      12.433113,
      0.886790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842752,
      3,
      0,
      0.196552,
      NULL,
      3.038564,
      0.394859,
      1.943480,
      1,
      1.255096,
      0,
      0,
      0,
      1.503005,
      NULL,
      0,
      0.442513,
      0.759477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.879439,
      '14412',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


