set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '213',
      '01',
      NULL,
      23.657528,
      '4312144',
      15,
      NULL,
      3,
      3,
      '031344',
      NULL,
      ' 7-23-1989',
      18,
      64.635192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.106029,
      NULL,
      0.139945,
      1.157969,
      0.795682,
      1.726447,
      2,
      1,
      2.906888,
      0,
      1,
      1.373429,
      3.770100,
      1,
      5.382145,
      1.003259,
      1,
      0,
      3.345553,
      0,
      2.683916,
      1.454341,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.694784,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238506,
      1.309320,
      1.624000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.908785,
      1,
      0.869738,
      0,
      0.253080,
      NULL,
      0.569077,
      1,
      NULL,
      0.019816,
      1.120627,
      0.525240,
      0,
      NULL,
      0.363337,
      NULL,
      1.763556,
      NULL,
      0.751426,
      2,
      0.880246,
      1.091942,
      1,
      0,
      4,
      0.178084,
      5.537896,
      2.088282,
      5,
      3,
      NULL,
      NULL,
      5.886177,
      NULL,
      NULL,
      3.308835,
      2.956793,
      2.421289,
      2.482710,
      NULL,
      NULL,
      9.678127,
      3.319272,
      0.373175,
      1.268138,
      1.007693,
      1.773869,
      NULL,
      NULL,
      7.147950,
      1.238825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653101,
      NULL,
      1,
      NULL,
      1.220444,
      1,
      0.895066,
      0.068762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.206933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.170391,
      2.622894,
      1.829877,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      4.263107,
      1.921902,
      2,
      4.084642,
      1.591835,
      NULL,
      NULL,
      NULL,
      0.348886,
      0.439639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.360922,
      3,
      NULL,
      1,
      2.573509,
      NULL,
      1.993527,
      3,
      1,
      NULL,
      0,
      0.897038,
      NULL,
      1,
      1,
      0,
      1,
      0.971175,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1.087528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


