set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '13',
      22.518248,
      7,
      NULL,
      116.321808,
      4,
      0,
      NULL,
      '122212',
      6.140968,
      ' 5-19-1996',
      50.842403,
      55.573341,
      1.444977,
      NULL,
      0,
      3.503604,
      1.802007,
      1.584932,
      1,
      NULL,
      2,
      0,
      0,
      1.744980,
      NULL,
      1,
      0.794294,
      0.359425,
      NULL,
      NULL,
      7,
      NULL,
      5.977908,
      0.214999,
      1,
      1,
      0,
      1,
      0.812779,
      0.733112,
      3.720806,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.454731,
      NULL,
      1,
      0,
      NULL,
      0.776506,
      NULL,
      0,
      2.808335,
      0.016459,
      1.974657,
      NULL,
      NULL,
      0.084148,
      NULL,
      NULL,
      0,
      0.885714,
      0,
      1,
      2,
      4.687328,
      NULL,
      1,
      1.953642,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.650758,
      0.112403,
      4.718152,
      1,
      2.827733,
      0,
      0,
      NULL,
      NULL,
      0.480124,
      1,
      NULL,
      1,
      1.133921,
      1.580099,
      1.556916,
      1.134913,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      5.023107,
      0.247112,
      5,
      NULL,
      1.481213,
      5,
      2.902247,
      4.872023,
      3.077199,
      1,
      5.503504,
      1,
      0,
      1.786597,
      7.236547,
      0,
      8,
      NULL,
      NULL,
      7.090755,
      2,
      4.149958,
      7.834825,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.102539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.796986,
      1.459539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.158980,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.336641,
      2,
      3.329282,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.187625,
      8.958496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679199,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.535100,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      1.243214,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '04403',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.318133,
      4.352634,
      2.347070,
      0.311025,
      3,
      2.705667,
      3,
      3,
      0.035542);
commit;
end;
/


