set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '402',
      '12333112',
      28,
      NULL,
      '4021203',
      230.313012,
      NULL,
      2,
      1,
      '424013',
      0,
      ' 1- 6-2000',
      9.490816,
      41.278668,
      0,
      NULL,
      1.896607,
      0.444587,
      1.244820,
      0,
      1,
      1,
      2,
      0.315939,
      1.748596,
      0.919367,
      5,
      1.340883,
      1.623468,
      1,
      1,
      1,
      2,
      0.050855,
      4.988430,
      3.670459,
      0,
      1.736739,
      5.601503,
      0,
      4.778303,
      0.812764,
      0,
      NULL,
      NULL,
      NULL,
      1.854023,
      NULL,
      NULL,
      3,
      1.458688,
      1.658395,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      1,
      1,
      0,
      1,
      0.874276,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.407847,
      1,
      1,
      NULL,
      0,
      5.523347,
      0.659900,
      3.732613,
      5,
      0.607297,
      3,
      0,
      NULL,
      4.031899,
      3.853811,
      1.106223,
      2.701617,
      NULL,
      3,
      1,
      NULL,
      6,
      2,
      4.744900,
      NULL,
      7,
      0.938374,
      1,
      7.369179,
      0.494233,
      NULL,
      4.894453,
      NULL,
      NULL,
      NULL,
      3.700764,
      0.539582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.556918,
      0,
      1,
      1,
      0.585881,
      1.091360,
      0.577370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.692635,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      7.332894,
      2.316804,
      NULL,
      1,
      0.211409,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211068,
      1.442223,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.556382,
      3,
      2.592292,
      0,
      1.571552,
      0,
      1,
      1.005643,
      1.624029,
      0.132193,
      NULL,
      0.207537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.806601,
      NULL,
      '',
      '',
      2,
      0.443836,
      3.102077,
      NULL,
      2.764636,
      2.144810,
      2,
      NULL,
      3);
commit;
end;
/


