set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '131',
      '31343234',
      6.852836,
      28.906812,
      NULL,
      23,
      5,
      1,
      0,
      '400122',
      1.988543,
      ' 8- 6-2001',
      NULL,
      NULL,
      1.977602,
      NULL,
      1.682441,
      2.322286,
      1,
      1.001709,
      0.071459,
      0.483865,
      3.683656,
      0,
      1,
      1,
      0.923105,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4.036553,
      4,
      NULL,
      0.830278,
      1,
      1.445610,
      0,
      2.429392,
      0,
      1.596120,
      1,
      NULL,
      NULL,
      0.837845,
      NULL,
      NULL,
      0.668240,
      1.412455,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.499266,
      1.683841,
      1.435649,
      1.061934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.626082,
      NULL,
      3.891417,
      1,
      0.137205,
      0,
      NULL,
      0.944814,
      1.868624,
      1.408593,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0.223779,
      NULL,
      0,
      5.945502,
      1,
      NULL,
      0.447266,
      0,
      NULL,
      1.704532,
      4,
      1.333179,
      4.996776,
      1,
      NULL,
      1,
      5,
      0.231761,
      2,
      NULL,
      7.445252,
      9.941863,
      5,
      5,
      NULL,
      8.508858,
      4,
      5,
      NULL,
      2.691670,
      1,
      NULL,
      NULL,
      2.821952,
      0.464086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663740,
      1.554064,
      0,
      1,
      0.628449,
      0,
      1.157289,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.764687,
      NULL,
      NULL,
      NULL,
      NULL,
      0.425243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.297857,
      1,
      2.438356,
      NULL,
      0,
      NULL,
      1.256723,
      NULL,
      NULL,
      NULL,
      0.893080,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.667813,
      1.481456,
      1,
      3,
      NULL,
      0.710286,
      1.238663,
      1,
      2.090941,
      0,
      1,
      1.246264,
      0,
      0,
      1.872686,
      0.016742,
      0,
      0.187091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.611061,
      '31104',
      '',
      '',
      1.159489,
      '',
      '',
      '',
      0.023580,
      '',
      '',
      '',
      3,
      2.928665,
      2.406275,
      3.301866,
      NULL,
      1,
      1.778879,
      0.749366,
      1);
commit;
end;
/


