set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '11010134',
      8,
      50,
      '1443410',
      52.886254,
      0,
      2,
      3,
      '203423',
      NULL,
      ' 1-18-1994',
      23,
      24,
      NULL,
      NULL,
      1,
      NULL,
      1.283156,
      1.120485,
      0.541606,
      NULL,
      3.212207,
      1,
      NULL,
      1,
      4.209606,
      0,
      0,
      1,
      0.212510,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      2.932426,
      4,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362798,
      1.360212,
      1,
      1.206564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580139,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.230597,
      0.917673,
      0.890684,
      0.275118,
      0.581121,
      1.585828,
      0,
      NULL,
      1.956856,
      NULL,
      0,
      0,
      0.276664,
      0,
      1,
      NULL,
      1.836312,
      NULL,
      1.766170,
      3,
      1,
      NULL,
      NULL,
      1.722780,
      0.454258,
      1,
      5.044829,
      2,
      2,
      2,
      2,
      1,
      2,
      1.730670,
      4,
      7,
      8,
      0,
      4,
      6,
      6,
      NULL,
      0,
      5,
      1,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533758,
      0,
      1,
      NULL,
      0.770458,
      1.174309,
      0.971028,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292564,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.932678,
      NULL,
      7.780602,
      9.151848,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.801744,
      1.894524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.585274,
      1.261251,
      0.849273,
      0.314316,
      3.649720,
      2.027460,
      1.657233,
      3,
      1,
      1.606999,
      3,
      1,
      1.542499,
      0.441912,
      0.806692,
      NULL,
      1,
      1,
      1,
      1.366662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '11112',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      3.872394,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.995339,
      3.642382);
commit;
end;
/


