set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      '23000023',
      74,
      9.512395,
      '1132114',
      218.002821,
      NULL,
      1,
      3,
      '331422',
      NULL,
      ' 0-24-1996',
      2,
      NULL,
      0.750662,
      NULL,
      0.809653,
      1.544298,
      1.827544,
      0.638552,
      1,
      0.479590,
      0.963319,
      0,
      1,
      1.525007,
      2.344152,
      0.757763,
      0,
      0.686798,
      0.258763,
      1,
      5.330141,
      1,
      4,
      NULL,
      NULL,
      1.142734,
      1,
      1,
      2.215050,
      NULL,
      3.120137,
      0,
      NULL,
      NULL,
      0.503571,
      NULL,
      NULL,
      5,
      1.097768,
      NULL,
      1,
      0,
      0.634087,
      NULL,
      NULL,
      0.600727,
      0.826781,
      0,
      1,
      0,
      3,
      0.212164,
      NULL,
      NULL,
      1,
      0.240766,
      4.285369,
      1.327971,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.220511,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.900898,
      1.279188,
      1.333201,
      NULL,
      0,
      0.708629,
      1,
      1.718792,
      1.757605,
      1,
      NULL,
      NULL,
      0,
      1.206342,
      NULL,
      1,
      NULL,
      1.949257,
      0.460724,
      4.292725,
      1,
      4.718636,
      1.985418,
      4,
      5,
      5,
      0.163649,
      2,
      1.163634,
      3,
      0.043656,
      5,
      NULL,
      1,
      4,
      5.392967,
      1,
      NULL,
      1.120266,
      6.407060,
      NULL,
      0.234223,
      3.170808,
      0.542487,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304765,
      1.001849,
      0,
      1,
      0,
      1,
      NULL,
      0.261508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      2,
      1.989651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4.908123,
      0.068760,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.823018,
      NULL,
      NULL,
      1.816226,
      NULL,
      2,
      2.811396,
      1,
      1.026837,
      0.538321,
      NULL,
      1,
      NULL,
      1.291602,
      1,
      1.512851,
      NULL,
      NULL,
      0.494495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.698277,
      '23332',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      5.959575,
      2,
      3.005431,
      3.025451,
      2.588317,
      3.032004,
      NULL,
      3.189021,
      1);
commit;
end;
/


