set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '104',
      '33033344',
      6.468757,
      61.990361,
      '3040130',
      289.857405,
      3,
      NULL,
      0,
      '100330',
      5,
      ' 8- 2-1986',
      50,
      58.655018,
      1.572908,
      NULL,
      0,
      0.803997,
      1,
      1.809137,
      0.025119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.588835,
      0.724352,
      0.695065,
      0.932539,
      0.337129,
      1.265493,
      6.054557,
      0.731399,
      2,
      1,
      NULL,
      0.834369,
      NULL,
      0,
      1,
      0,
      NULL,
      0.031431,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.404684,
      1.586308,
      1,
      NULL,
      1.502464,
      0,
      0,
      0.363174,
      0,
      1,
      1,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      1,
      2,
      0,
      0,
      5.547715,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.373009,
      NULL,
      NULL,
      0,
      1.242020,
      3.269666,
      0,
      1.505729,
      NULL,
      0,
      1.771919,
      NULL,
      0.015146,
      NULL,
      1.750678,
      NULL,
      1,
      NULL,
      1,
      0,
      1.212204,
      1.862989,
      NULL,
      NULL,
      5.092598,
      1,
      5.134873,
      3.657601,
      1.337576,
      3,
      NULL,
      4,
      4.971198,
      1,
      0,
      3.456951,
      1.285518,
      2.835403,
      0,
      3.467382,
      1,
      3,
      NULL,
      NULL,
      0,
      NULL,
      5.803292,
      8.100539,
      2,
      1.143004,
      5,
      1.340980,
      NULL,
      NULL,
      1,
      1.529015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.356140,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.986341,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.714870,
      2.598657,
      3,
      3.197758,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.640264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698536,
      0.484317,
      NULL,
      0.230257,
      3,
      3,
      2.676834,
      1.427627,
      NULL,
      NULL,
      2.624500,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1.509523,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '12402',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3,
      '0001',
      NULL,
      '',
      1.107920,
      NULL,
      2,
      NULL,
      2.853265,
      2.961858,
      3,
      3,
      1.237537);
commit;
end;
/


