set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1422',
      '42032024',
      52,
      25.182024,
      '1123310',
      71,
      3,
      3,
      0,
      '432333',
      2,
      ' 3- 2-1990',
      6,
      56.960322,
      1.796292,
      NULL,
      0.800921,
      1.049639,
      0,
      1.986605,
      0.878303,
      NULL,
      3.276083,
      NULL,
      1.559368,
      0,
      1.183019,
      0.555252,
      1,
      0,
      0.767965,
      NULL,
      NULL,
      3,
      1.206306,
      0.974884,
      3,
      3,
      4.306031,
      1,
      NULL,
      0,
      0.851014,
      0.002509,
      NULL,
      NULL,
      0.440903,
      NULL,
      NULL,
      3.365140,
      1.529494,
      NULL,
      1,
      1.737347,
      1,
      0,
      1,
      3,
      1,
      0,
      1.980189,
      0,
      1,
      NULL,
      1.663708,
      0.564693,
      0,
      0,
      0.661782,
      1.932362,
      1,
      3.535228,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.157800,
      NULL,
      1.604896,
      2.069545,
      NULL,
      0,
      NULL,
      0.779500,
      0,
      1.101711,
      1.691036,
      0,
      1.141319,
      NULL,
      0.825024,
      0,
      NULL,
      1.421353,
      NULL,
      1,
      NULL,
      3,
      1.860795,
      4.701483,
      0.137305,
      2.188241,
      1,
      3,
      NULL,
      NULL,
      3.563465,
      4,
      4.503720,
      0.263031,
      1,
      3.353169,
      5.299624,
      6,
      1.623310,
      NULL,
      5,
      0.454297,
      NULL,
      5,
      2,
      1,
      0,
      1.363114,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522565,
      0.686551,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      3.602513,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      0,
      5,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.182237,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      1.252111,
      3,
      3.738976,
      NULL,
      NULL,
      1.913048,
      1,
      0.642903,
      1,
      0.178445,
      1.703083,
      1,
      0,
      1,
      0.078106,
      0.466636,
      1.144667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.354683,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      '1003',
      NULL,
      '',
      NULL,
      5,
      3,
      1,
      2,
      3.584199,
      3.225364,
      3.404817,
      3.663046);
commit;
end;
/


