set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '430',
      '43',
      1,
      15,
      '2044304',
      3.021708,
      NULL,
      0.323380,
      1,
      '122113',
      2,
      NULL,
      NULL,
      24,
      1.551112,
      NULL,
      2.071407,
      0.083488,
      3,
      1.653860,
      1,
      NULL,
      0.001241,
      1,
      0,
      0.749967,
      NULL,
      0.413867,
      0.738759,
      0,
      0,
      2.651147,
      NULL,
      1.964450,
      1.937697,
      NULL,
      1,
      0.665186,
      NULL,
      NULL,
      3.591281,
      NULL,
      0.342057,
      NULL,
      NULL,
      NULL,
      1.992166,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.736653,
      0.021054,
      NULL,
      1,
      2.520886,
      NULL,
      NULL,
      3.863843,
      0,
      1,
      2.961659,
      1,
      1,
      1,
      3.609780,
      2.932524,
      NULL,
      3,
      7,
      7.211915,
      1,
      0,
      2.761650,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.830433,
      1,
      1.491189,
      NULL,
      0.972584,
      0.439053,
      NULL,
      1.737446,
      0,
      1,
      0.649431,
      1,
      0,
      1.714809,
      0.253232,
      0.050930,
      0.882804,
      NULL,
      1.796041,
      1,
      0.452804,
      0,
      0,
      1,
      1.207951,
      1.566359,
      NULL,
      1.539157,
      0,
      0.775984,
      0,
      NULL,
      2.265613,
      0,
      1.930965,
      0,
      2.869520,
      NULL,
      4,
      0.006686,
      2.592893,
      NULL,
      6.673348,
      NULL,
      1,
      1.980972,
      3,
      1.475215,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.736997,
      0,
      1,
      1.296503,
      0,
      1.481182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458269,
      NULL,
      NULL,
      NULL,
      NULL,
      4.311411,
      1,
      2.520444,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.422062,
      0.291217,
      3.368111,
      4,
      1.607026,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.880569,
      5.344315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.192714,
      NULL,
      1.865285,
      NULL,
      1.298810,
      0,
      1,
      0,
      0.768249,
      1.389110,
      1.879357,
      0,
      1.233367,
      0,
      0.364376,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.197967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749370,
      0,
      3.099652,
      NULL,
      2.247865,
      NULL,
      1.224628,
      1.202380,
      1.651291,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334457,
      NULL,
      NULL,
      NULL,
      NULL,
      0.563042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '11223',
      '14143',
      '',
      3.667055,
      '3203',
      NULL,
      '',
      NULL,
      '41130',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


