set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      '03',
      NULL,
      NULL,
      '4040103',
      27,
      NULL,
      0.796025,
      0,
      NULL,
      4.188052,
      '10- 5-2000',
      31.501188,
      58,
      0.252421,
      NULL,
      3.007925,
      0.284519,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.105381,
      1,
      4,
      1,
      0.961019,
      NULL,
      1.425682,
      1.326370,
      8.255123,
      NULL,
      1,
      5.933292,
      NULL,
      1,
      4,
      1,
      5.472666,
      0,
      1.682206,
      1.576229,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.312934,
      1,
      0,
      0.256931,
      NULL,
      1.196321,
      NULL,
      0.290441,
      1.888221,
      1,
      1.089216,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.946276,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      3.076996,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      4,
      3,
      NULL,
      1,
      0,
      0,
      1.899537,
      NULL,
      0.452205,
      0.681068,
      1,
      0,
      0.990618,
      NULL,
      0.871106,
      0.823917,
      NULL,
      NULL,
      1.964593,
      5.427907,
      0.551968,
      0,
      1.295477,
      1,
      0.723877,
      0,
      4,
      1,
      0.381248,
      1.427771,
      NULL,
      1.596221,
      4,
      0.745668,
      3,
      6.371907,
      1.249579,
      NULL,
      5,
      5.559678,
      0.123293,
      9,
      NULL,
      0,
      1.585761,
      1,
      NULL,
      1.034250,
      1,
      1.236871,
      0.011296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.439271,
      1.740455,
      1,
      0,
      1.312266,
      1.141824,
      1,
      1.041162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697592,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      3.105281,
      NULL,
      NULL,
      0.570643,
      0,
      NULL,
      0.270053,
      2,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.474068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705742,
      3,
      3.685894,
      NULL,
      3,
      3,
      3.946709,
      0.889360,
      1,
      2.607515,
      3,
      1.932615,
      1,
      0.437258,
      1,
      0,
      0,
      1,
      0.211654,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '14140',
      '41112',
      '',
      1,
      '',
      '',
      '',
      1,
      '21212',
      '',
      '',
      2.358292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


