set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '331',
      '04',
      35,
      NULL,
      '2140404',
      40,
      1,
      0,
      NULL,
      NULL,
      3,
      ' 0-18-1984',
      27,
      27,
      0.844970,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2.179923,
      0,
      0.336875,
      0.388077,
      NULL,
      0,
      NULL,
      1.227611,
      1,
      1,
      1,
      3,
      NULL,
      0,
      1.061647,
      1,
      0,
      0,
      NULL,
      NULL,
      5.007593,
      1,
      NULL,
      1.426821,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.810731,
      5,
      0,
      NULL,
      1,
      NULL,
      0.764982,
      NULL,
      2.726437,
      1,
      1.915438,
      2,
      2,
      1.450037,
      1.933600,
      2.973537,
      0,
      2.321169,
      2,
      1.512594,
      4.666777,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.692840,
      NULL,
      NULL,
      0.196092,
      2,
      NULL,
      0.261331,
      2.645479,
      1.143064,
      1.751023,
      1.629023,
      0,
      1.612098,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.027514,
      NULL,
      0.688001,
      NULL,
      NULL,
      NULL,
      2,
      1.139986,
      0,
      0,
      NULL,
      NULL,
      1.915476,
      0,
      4,
      0.817730,
      0,
      0.858260,
      0,
      4,
      3,
      3,
      NULL,
      NULL,
      7.359072,
      0.896805,
      0,
      1.974276,
      2.275740,
      0,
      NULL,
      5.479474,
      0.657028,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.671007,
      NULL,
      0.755702,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.805231,
      0.493006,
      2,
      1,
      NULL,
      3.814313,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.599404,
      NULL,
      1.872118,
      1.505803,
      NULL,
      1.227725,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000039,
      NULL,
      2.807829,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.986585,
      0.955189,
      0.428270,
      1.380224,
      1.195543,
      0,
      1.412248,
      0,
      NULL,
      0.646782,
      0.964902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '00033',
      '',
      '',
      1.230309,
      '',
      '',
      '',
      1,
      '03101',
      '',
      '',
      1.799800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


