set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '44',
      NULL,
      0,
      NULL,
      2.253700,
      4,
      2.456673,
      NULL,
      '023111',
      4.010842,
      ' 2- 9-1996',
      24.496102,
      11.499563,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.565384,
      1,
      0,
      1.901002,
      4.542281,
      NULL,
      0,
      NULL,
      0.901783,
      1,
      2.217141,
      1.712673,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1.624600,
      NULL,
      NULL,
      0.236359,
      NULL,
      NULL,
      9.957291,
      1,
      0.143792,
      1.628051,
      1.819200,
      1.924687,
      1.210724,
      0,
      NULL,
      0.443369,
      NULL,
      1.729423,
      3,
      1.096481,
      1.813342,
      0.827112,
      NULL,
      3,
      NULL,
      NULL,
      1.049623,
      3,
      7.470618,
      1,
      2,
      1.282408,
      0,
      NULL,
      NULL,
      0.656930,
      NULL,
      NULL,
      0.074395,
      1.601267,
      4,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1.583287,
      NULL,
      0.740251,
      1,
      0,
      1,
      0,
      NULL,
      1.177423,
      NULL,
      NULL,
      NULL,
      5,
      1.897467,
      1.933652,
      0,
      1.410496,
      0,
      1.050157,
      0,
      1.306725,
      0.561639,
      NULL,
      1.340076,
      0,
      NULL,
      1.278744,
      NULL,
      0.877418,
      0,
      3.512113,
      0.109926,
      4.799437,
      1,
      1.438681,
      3.251268,
      0,
      NULL,
      1.493110,
      NULL,
      1.135340,
      0.614189,
      0.031338,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308648,
      1.581812,
      NULL,
      0,
      0,
      1,
      2.124718,
      1.085851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288552,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.517176,
      1,
      0.771747,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.208785,
      3,
      NULL,
      1.221019,
      NULL,
      1.742085,
      0.548546,
      1,
      NULL,
      1,
      1.481248,
      1,
      0.938984,
      NULL,
      0.060585,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '42020',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


