set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '31',
      30.428416,
      42.616175,
      NULL,
      30,
      0,
      0,
      3,
      '413413',
      5,
      ' 0-10-1980',
      11,
      24,
      NULL,
      NULL,
      2.723861,
      NULL,
      2,
      1.414293,
      NULL,
      0,
      0,
      0,
      1.115222,
      0.341526,
      5,
      1.254691,
      1.490201,
      1,
      1,
      1.885597,
      8,
      0.383213,
      4,
      1,
      1,
      0.790689,
      0.846872,
      0,
      5,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10.470098,
      NULL,
      1,
      NULL,
      1.856517,
      1,
      3,
      1,
      3,
      NULL,
      0.228583,
      1,
      1,
      NULL,
      1.515595,
      0,
      2.516523,
      2.174795,
      1,
      0.057858,
      1,
      NULL,
      NULL,
      1,
      1,
      0.371602,
      NULL,
      NULL,
      NULL,
      0.688369,
      NULL,
      NULL,
      0,
      NULL,
      1.221294,
      NULL,
      NULL,
      0.361771,
      1.558778,
      0,
      1,
      1,
      0.112831,
      0.064046,
      1,
      NULL,
      0.252970,
      0,
      1,
      0,
      1.243074,
      NULL,
      0,
      3,
      1.055410,
      1,
      0.124482,
      0.944313,
      2.394732,
      1.793696,
      0.735496,
      0.497098,
      0.059195,
      0,
      0.357402,
      0,
      NULL,
      0,
      0,
      4,
      1,
      0,
      5,
      2,
      0.788251,
      0.159620,
      NULL,
      1.765357,
      1.300487,
      0,
      3,
      4.003886,
      1,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.890233,
      0,
      1.841629,
      1.089956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.641024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.844380,
      NULL,
      1,
      NULL,
      1.291790,
      0,
      0.982892,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.707883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730686,
      1.065928,
      NULL,
      3.529458,
      1.558092,
      0,
      0,
      0.188085,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.614770,
      1.859581,
      NULL,
      0,
      1,
      1.814818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.956820,
      '20343',
      '',
      NULL,
      0.607299,
      '',
      '',
      '',
      1.742458,
      '',
      '',
      '',
      NULL,
      3,
      3,
      1,
      3.078295,
      NULL,
      2,
      1.935759,
      NULL);
commit;
end;
/


