set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '421',
      '41144012',
      NULL,
      NULL,
      NULL,
      14.349623,
      6,
      1,
      0,
      '402404',
      1,
      '10- 3-2002',
      39,
      53,
      NULL,
      NULL,
      1.216767,
      3.845282,
      0.758846,
      1,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      6,
      1.231096,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.884771,
      0.471184,
      2.370894,
      1.599066,
      1.243067,
      NULL,
      0,
      NULL,
      0,
      0.193091,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3,
      1,
      0,
      0.360213,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0.917285,
      0,
      0,
      0,
      1.623024,
      NULL,
      NULL,
      NULL,
      NULL,
      5.395505,
      7.953424,
      1,
      0,
      2.946780,
      NULL,
      NULL,
      NULL,
      1.064151,
      NULL,
      NULL,
      NULL,
      NULL,
      3.097282,
      1.233523,
      3,
      1.422329,
      1.056250,
      NULL,
      1,
      0.500382,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0.459204,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      1.075503,
      0.553380,
      1,
      NULL,
      0.921139,
      NULL,
      0,
      1,
      1,
      1,
      0.926525,
      0.280652,
      0.285123,
      0.826433,
      6.661989,
      1,
      2,
      6.458377,
      2.462965,
      NULL,
      1.015303,
      5.193951,
      0.780684,
      4,
      0.663443,
      0.848102,
      1.045089,
      2,
      0.098105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.955312,
      0,
      1,
      1.748173,
      0,
      1,
      0.191162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.403913,
      3,
      1.913423,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.155878,
      5.186286,
      0,
      1,
      1.149592,
      NULL,
      NULL,
      NULL,
      1.576366,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816804,
      1,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      0.330459,
      2,
      1,
      1,
      0,
      1.371825,
      0.416651,
      1,
      0.130458,
      1.202468,
      0,
      1.700127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '04344',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      5,
      0.479528,
      5.384941,
      NULL,
      2.167506,
      0.506299,
      3,
      2.301164,
      1);
commit;
end;
/


