set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '044',
      '40034431',
      NULL,
      52,
      '2113110',
      NULL,
      3,
      0,
      0,
      '232014',
      4.336914,
      ' 3-13-1988',
      15,
      34.928592,
      0.198995,
      NULL,
      NULL,
      1,
      1.038191,
      1.884483,
      1,
      1.206485,
      1,
      1,
      3.048881,
      1,
      1,
      0.156238,
      0.164601,
      1,
      1.153315,
      1,
      8,
      NULL,
      0,
      1,
      0.098106,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.834244,
      0,
      NULL,
      NULL,
      1.388185,
      NULL,
      NULL,
      2.467880,
      1,
      NULL,
      NULL,
      NULL,
      0.106567,
      1.027977,
      2,
      2.780460,
      2.956120,
      3,
      NULL,
      0.420725,
      0,
      0,
      NULL,
      0.342792,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852590,
      1,
      2,
      1.715606,
      1.044224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.141127,
      1,
      NULL,
      0,
      1.325487,
      0.233227,
      NULL,
      1,
      NULL,
      NULL,
      1.079161,
      1,
      1.839906,
      NULL,
      0.344270,
      1.685339,
      1,
      NULL,
      0.886280,
      1,
      1.544445,
      NULL,
      0.432673,
      1.762349,
      0,
      1.328155,
      1,
      1,
      0.655682,
      1,
      0,
      1.876135,
      0.994788,
      NULL,
      0,
      5.780018,
      7.483483,
      NULL,
      2,
      6,
      2.022257,
      4,
      3,
      5,
      5,
      2,
      2.464423,
      0.506593,
      0.978542,
      0,
      0.060190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      0.765455,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8.416477,
      3,
      0,
      0.947507,
      NULL,
      0.181853,
      6,
      3.971522,
      0.250424,
      NULL,
      NULL,
      NULL,
      0,
      1.012872,
      1.603726,
      3.545937,
      3.050680,
      2,
      7,
      3.691576,
      0,
      NULL,
      0,
      5.985208,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285934,
      NULL,
      2.621336,
      3.918354,
      0.990639,
      3,
      NULL,
      0.472119,
      NULL,
      NULL,
      0.222880,
      0.620085,
      NULL,
      1,
      1.101149,
      1,
      1.648682,
      0.537513,
      0.445877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.627800,
      NULL,
      1.098676,
      0,
      0.495299,
      1,
      1.209006,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      3.275104,
      '12400',
      NULL,
      '',
      2.241750,
      2.643674,
      NULL,
      0.145294,
      2,
      1,
      0.954181,
      NULL,
      NULL);
commit;
end;
/


