set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '43040441',
      NULL,
      NULL,
      '1341242',
      57.711203,
      NULL,
      0.518253,
      NULL,
      '034112',
      5.316768,
      ' 3- 6-2003',
      0.259337,
      5,
      1.666921,
      NULL,
      3.402024,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      8.397447,
      1.507094,
      0.777661,
      1.532695,
      0.476868,
      3,
      7.826938,
      1,
      1,
      0.664007,
      3,
      0,
      6,
      0,
      3,
      1.420493,
      1,
      0.845677,
      NULL,
      NULL,
      0.705187,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      2.491480,
      1,
      NULL,
      NULL,
      1,
      0.742056,
      2,
      0.592425,
      2,
      0,
      0.414046,
      2,
      0,
      2.786277,
      7,
      0.892554,
      3.071623,
      1,
      NULL,
      2.048844,
      1.512600,
      NULL,
      NULL,
      1.887639,
      NULL,
      NULL,
      0,
      0,
      1.013640,
      0,
      NULL,
      0,
      0,
      1.617978,
      1.718664,
      0.733518,
      0.421326,
      0.122758,
      0.942109,
      0.873447,
      1,
      0,
      1,
      0.444948,
      NULL,
      NULL,
      1.963620,
      NULL,
      NULL,
      0,
      1,
      0.851816,
      0,
      NULL,
      1,
      0.199979,
      NULL,
      1.970486,
      0,
      NULL,
      0,
      1,
      NULL,
      3,
      7,
      1,
      NULL,
      5,
      2.685329,
      9.502226,
      0.561985,
      3.105091,
      3,
      1.343644,
      NULL,
      NULL,
      0.783633,
      3,
      0.447357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219485,
      0.470884,
      1,
      0,
      1.346706,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.379694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.447276,
      1.481567,
      NULL,
      NULL,
      NULL,
      3,
      1.532359,
      NULL,
      0.486204,
      1.348504,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.671604,
      3.478288,
      2.483537,
      0,
      0.660700,
      0,
      NULL,
      NULL,
      1,
      0.309493,
      0.101449,
      1.323771,
      1.097434,
      1,
      0,
      0,
      0.147599,
      1.509774,
      NULL,
      0.570917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.950628,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '',
      NULL,
      2.331491,
      2.961964,
      3,
      1.511349,
      0,
      NULL,
      NULL,
      1.357508);
commit;
end;
/


