set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '42001041',
      NULL,
      24,
      NULL,
      27,
      6,
      2,
      3,
      '432032',
      4.361559,
      ' 4- 9-1979',
      NULL,
      62.455265,
      1.166660,
      NULL,
      3,
      1.037198,
      3,
      0,
      1.711465,
      3,
      0,
      0.435020,
      2.747896,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.103215,
      1,
      11,
      1.817949,
      0,
      9.366799,
      0.113506,
      1.105649,
      1,
      1,
      5.021228,
      0.153048,
      0.381285,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.634274,
      1,
      NULL,
      0.035873,
      2,
      3.422055,
      1,
      0.083333,
      1,
      2,
      2.135481,
      0,
      NULL,
      0.210684,
      3.250832,
      2,
      1,
      0.744473,
      6.499234,
      6.259801,
      6,
      1,
      1,
      3.129560,
      0.488973,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.284896,
      2.522079,
      1,
      1.984684,
      0.455862,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      1.801790,
      NULL,
      0.769929,
      0.437365,
      1,
      NULL,
      1.503062,
      NULL,
      0,
      0,
      1.220508,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.027909,
      1.739145,
      0,
      1.580003,
      0,
      2,
      NULL,
      1.298210,
      1,
      5,
      1.301223,
      1,
      4,
      7.764932,
      NULL,
      10.678362,
      0.730253,
      5,
      1.904297,
      NULL,
      NULL,
      1.208070,
      0,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.720801,
      1,
      1.124768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.789671,
      0,
      1.580040,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.964554,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      0.399865,
      2.527773,
      NULL,
      NULL,
      1,
      0,
      1,
      1.484640,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '42420',
      '',
      '',
      1.898198,
      '',
      NULL,
      '',
      2.682371,
      '33312',
      '',
      '',
      2,
      2.836318,
      1,
      1.933493,
      1.271308,
      2,
      1.265671,
      NULL,
      1);
commit;
end;
/


