set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '212',
      '20214342',
      36,
      52,
      '4203312',
      89,
      3,
      NULL,
      0,
      NULL,
      6,
      NULL,
      NULL,
      26.306526,
      0.936962,
      NULL,
      0.846235,
      1,
      3.340557,
      0,
      NULL,
      0.950593,
      NULL,
      0.913734,
      2.958809,
      1,
      3.048606,
      0.315322,
      0.672119,
      1.287336,
      NULL,
      1.142577,
      6.408885,
      0.766713,
      8,
      6,
      NULL,
      1.652150,
      5,
      0,
      4,
      1.412840,
      3.899417,
      1.628961,
      NULL,
      NULL,
      0.499093,
      NULL,
      NULL,
      6,
      1,
      0,
      3,
      0.566906,
      1,
      2,
      0.762064,
      NULL,
      3.046293,
      NULL,
      0.647047,
      1.463313,
      NULL,
      0.223578,
      0,
      3,
      2.220683,
      2,
      1,
      NULL,
      3.929828,
      7,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.236287,
      0.332806,
      1,
      1,
      NULL,
      NULL,
      0,
      0.760255,
      1,
      0.651735,
      1,
      0.547960,
      0.999037,
      0,
      0.966539,
      0.690189,
      1,
      1.283787,
      0.889449,
      NULL,
      1,
      NULL,
      1,
      1.344489,
      1.870165,
      1.305220,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0,
      1,
      0.797465,
      6.084523,
      NULL,
      0.645067,
      0.658338,
      0,
      8.053206,
      4,
      NULL,
      4.885706,
      4.068550,
      1.211956,
      NULL,
      NULL,
      6.057384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456554,
      0.095826,
      0,
      NULL,
      1,
      NULL,
      1.020641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      1,
      2.401989,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1.119443,
      1,
      0.890248,
      1.878426,
      0,
      1.194701,
      1.791344,
      NULL,
      1,
      NULL,
      0.432036,
      0.397727,
      NULL,
      0.312052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.830982,
      '23034',
      '',
      '',
      0.577275,
      '',
      '',
      '',
      1.542492,
      NULL,
      NULL,
      '',
      NULL,
      5.571536,
      2.946985,
      NULL,
      NULL,
      1,
      0,
      2.396159,
      0.521790);
commit;
end;
/


