set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23330334',
      35,
      NULL,
      '3412031',
      NULL,
      1,
      1.930088,
      NULL,
      '220311',
      4.249841,
      ' 2-10-1999',
      3.936086,
      24,
      0.980814,
      NULL,
      0.462311,
      0.430047,
      2,
      1.294279,
      0.875586,
      0.841315,
      1.666698,
      1,
      1,
      0.357168,
      1.397789,
      0,
      0.009939,
      0.783943,
      1.115870,
      1.548382,
      9.270391,
      1,
      5.707812,
      NULL,
      3,
      NULL,
      4,
      0,
      NULL,
      0.772376,
      3.737754,
      0,
      NULL,
      NULL,
      1.997511,
      NULL,
      NULL,
      3.361594,
      7.948024,
      1,
      0,
      0,
      0,
      2,
      0,
      0,
      1,
      0,
      1.336809,
      0,
      NULL,
      0,
      0.398382,
      1.796458,
      0,
      0.802310,
      4.171942,
      2,
      0,
      8,
      0,
      2,
      0,
      0.568290,
      NULL,
      NULL,
      1.924770,
      NULL,
      NULL,
      1.559796,
      1,
      1.645522,
      0.036320,
      1.268155,
      0,
      NULL,
      1,
      1.694478,
      1.029371,
      NULL,
      1,
      1,
      0,
      1.155094,
      0.931454,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      0.797476,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0.786833,
      6.289849,
      7.584359,
      NULL,
      NULL,
      4.408059,
      11,
      2.050037,
      4,
      2,
      NULL,
      2,
      0.561746,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1.059816,
      NULL,
      1.584896,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206369,
      NULL,
      NULL,
      NULL,
      NULL,
      0.626159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.246277,
      0.918105,
      1.292421,
      1,
      1.459391,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.047998,
      NULL,
      1.301755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924817,
      3,
      NULL,
      0,
      0,
      1,
      3.585491,
      1,
      1.236872,
      0,
      0,
      1.347238,
      0,
      0,
      0,
      1.671968,
      0.959515,
      1.798415,
      1.512312,
      0.708797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.258456,
      '10321',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      5,
      NULL,
      1.145524,
      NULL,
      2.625119,
      0,
      1,
      NULL,
      1);
commit;
end;
/


