set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4430',
      '02303231',
      24,
      7,
      '4403231',
      33.661069,
      3,
      0.458536,
      NULL,
      '013443',
      4.478521,
      '10- 0-1987',
      8,
      36,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      0.292325,
      1.861987,
      1,
      NULL,
      1.040750,
      1,
      2,
      1.606597,
      0.354718,
      1,
      0,
      2.449021,
      7,
      1,
      0,
      4.204895,
      2,
      NULL,
      5,
      0,
      NULL,
      3.289872,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.559629,
      2,
      2,
      0,
      0,
      0.693024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.799580,
      1,
      0.328581,
      1,
      0.376510,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      0.287336,
      NULL,
      0,
      1.382828,
      1.501528,
      1,
      0,
      0,
      NULL,
      0.961562,
      NULL,
      1,
      NULL,
      1,
      1,
      1.520398,
      2.832528,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.408844,
      3,
      0.200770,
      1,
      NULL,
      NULL,
      4.586334,
      4.680146,
      0.661806,
      NULL,
      3,
      9,
      2.827797,
      2.671083,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424462,
      0,
      NULL,
      0,
      1.466124,
      1.461869,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852786,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.724231,
      NULL,
      1.801011,
      2.682824,
      2.592797,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.650123,
      2,
      0.894932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565774,
      2.181971,
      NULL,
      1.807607,
      1.223617,
      0,
      1,
      2,
      1.130441,
      NULL,
      1,
      1.057621,
      NULL,
      0.124091,
      1.849761,
      0,
      1,
      1,
      NULL,
      0.847271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32043',
      '',
      '',
      1.313758,
      '',
      '',
      NULL,
      2,
      '30303',
      NULL,
      '',
      NULL,
      3,
      0.379321,
      0,
      2,
      4.090073,
      NULL,
      0.053401,
      3);
commit;
end;
/


