set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1343',
      '23224133',
      NULL,
      27.973681,
      '0322023',
      61.695932,
      3,
      1,
      1,
      NULL,
      NULL,
      ' 7- 9-2002',
      24,
      42.949054,
      NULL,
      NULL,
      0,
      NULL,
      1.836704,
      1,
      0,
      1,
      NULL,
      0.093433,
      1.116965,
      0.278250,
      1,
      0.297740,
      1.947486,
      0,
      1,
      0,
      0,
      1,
      1.434014,
      7.144069,
      10.990040,
      0,
      0.500965,
      1,
      0,
      0.137286,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.764323,
      7.379756,
      1.506193,
      1,
      1,
      1.745283,
      NULL,
      0.961250,
      1.044816,
      1.437265,
      2.021660,
      1,
      1,
      2.932268,
      0.796578,
      1.010418,
      0,
      0,
      0.939085,
      0.657742,
      1.710949,
      2,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.665279,
      NULL,
      NULL,
      0.626695,
      0.611116,
      NULL,
      0.571521,
      1.736066,
      1,
      0,
      0.750873,
      0,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1.136696,
      1.539718,
      1,
      0.126390,
      NULL,
      1,
      NULL,
      1.576151,
      0.044725,
      0,
      1,
      0.888950,
      0.585896,
      1,
      NULL,
      0,
      0.211126,
      NULL,
      5,
      3,
      NULL,
      1,
      3.397572,
      0.281652,
      3.281404,
      NULL,
      4,
      6,
      5,
      4.903035,
      1.171433,
      NULL,
      NULL,
      1.381106,
      0.643431,
      NULL,
      6,
      0.028914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.884949,
      0.537708,
      0,
      1,
      0,
      0.798032,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.155789,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.239112,
      2,
      1,
      0.758902,
      0,
      NULL,
      3.372186,
      1.772752,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019896,
      NULL,
      3.449133,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.984325,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.396294,
      0.574248,
      NULL,
      3.500182,
      0,
      1,
      3.543702,
      0.828002,
      0,
      2.933527,
      1,
      1,
      1.322323,
      0.089163,
      NULL,
      1,
      1,
      1.862375,
      0.895938,
      1.681171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3,
      3.842690,
      NULL,
      0,
      1,
      2.808310,
      2,
      NULL,
      1.378173);
commit;
end;
/


