set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9331536';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3142',
      '20314024',
      NULL,
      30.472020,
      NULL,
      29,
      2,
      1,
      2,
      '433331',
      1,
      ' 1-12-1985',
      NULL,
      38.029473,
      0,
      NULL,
      0,
      0.737379,
      3.120956,
      1,
      NULL,
      0,
      NULL,
      1.844700,
      0.709091,
      0,
      4,
      0,
      1,
      0.779978,
      1.620102,
      5.947098,
      6,
      1.320786,
      NULL,
      4,
      2.586883,
      0.735924,
      3.039576,
      NULL,
      0,
      1.405783,
      3,
      1.736897,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.010384,
      1.575057,
      0.444245,
      1,
      1.306997,
      NULL,
      1.762380,
      0.030070,
      NULL,
      1.976769,
      NULL,
      2.973220,
      1,
      2.728865,
      0.318383,
      0.338455,
      1,
      1.683341,
      1,
      NULL,
      5.926632,
      5.757476,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.641483,
      NULL,
      NULL,
      1.448620,
      0.742081,
      1,
      0,
      NULL,
      0.981946,
      NULL,
      NULL,
      1.604585,
      1,
      1,
      NULL,
      0,
      0.608797,
      0.432539,
      NULL,
      0.462954,
      1,
      1.326348,
      NULL,
      0.539742,
      NULL,
      0.558665,
      1,
      1.241909,
      0.423832,
      0.976515,
      0,
      2,
      0,
      0,
      1,
      3.657038,
      1,
      NULL,
      0.875368,
      0.057777,
      1.108440,
      3,
      4,
      3,
      3,
      NULL,
      8.724883,
      5,
      1,
      0,
      1.869772,
      1.183990,
      0.951117,
      0,
      3,
      0.267937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.857558,
      0.773011,
      1,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.281213,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.690810,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.887104,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.022272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.869118,
      0.919124,
      0,
      3.757328,
      2,
      NULL,
      0.039380,
      3,
      0.436927,
      NULL,
      0,
      0,
      1,
      1.316408,
      1.551032,
      1.171390,
      0.705327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.995448,
      '44343',
      '',
      '',
      1.670689,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      0,
      1,
      3.282669,
      3,
      1.010043,
      2,
      0.721536);
commit;
end;
/


