set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      '24',
      33.532635,
      4,
      '4113304',
      37,
      1,
      2.824737,
      1,
      '421214',
      3.428403,
      ' 2- 5-2000',
      16,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.526014,
      NULL,
      1,
      1.326492,
      1.546833,
      NULL,
      NULL,
      0.262813,
      1,
      1.001510,
      NULL,
      3,
      1.411738,
      1,
      3.559031,
      NULL,
      0.128006,
      1.333282,
      NULL,
      1.678624,
      NULL,
      1,
      0.324407,
      2,
      5.685570,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.106608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330097,
      0.471413,
      1.826298,
      0.150711,
      NULL,
      NULL,
      NULL,
      NULL,
      2.986785,
      1.525739,
      0,
      1.928962,
      NULL,
      NULL,
      0,
      1.292912,
      0.921293,
      0.598224,
      NULL,
      NULL,
      1,
      3.693838,
      NULL,
      2.524465,
      1.096173,
      0,
      0.683564,
      1.993467,
      0,
      1,
      4,
      NULL,
      0,
      0.544411,
      2,
      1.019309,
      2,
      NULL,
      7,
      8.901315,
      2,
      NULL,
      2.955500,
      0,
      1,
      NULL,
      1,
      4,
      0,
      NULL,
      1,
      3.382687,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      1.252032,
      0.444055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.887363,
      NULL,
      1.830498,
      1.838076,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.578395,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028283,
      2.834895,
      1.036340,
      1.404865,
      0,
      1,
      NULL,
      0.161115,
      NULL,
      NULL,
      NULL,
      0.206755,
      1,
      NULL,
      0.303770,
      0,
      0.660906,
      0,
      1.947522,
      3.797546,
      1,
      1,
      1,
      0.902985,
      0,
      3.052215,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1.820370,
      1,
      NULL,
      3,
      NULL,
      1.278015,
      1.552570,
      0.473020,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.677528,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859335,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      7,
      NULL,
      0,
      3.202857,
      0,
      4.826662,
      '44240',
      NULL,
      '20410',
      1.598421,
      '',
      '',
      '',
      1.784245,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


