set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-5-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      '401001',
      0,
      ' 2-15-1986',
      4.847011,
      NULL,
      0,
      NULL,
      0.993803,
      3,
      0.202485,
      0.159135,
      0,
      0.145637,
      3.441481,
      NULL,
      1.255876,
      NULL,
      5.099132,
      NULL,
      0.901650,
      1,
      1,
      7,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      4.121829,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.650317,
      6.355872,
      NULL,
      1.702007,
      NULL,
      0,
      2.363064,
      3,
      NULL,
      2,
      2.277166,
      2.583905,
      NULL,
      0,
      1.116984,
      0.432957,
      2,
      0.906886,
      NULL,
      NULL,
      8,
      3,
      4,
      1,
      1,
      0,
      1.585035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0,
      3,
      2.297180,
      1.443957,
      2.507577,
      8.232707,
      1,
      1.767265,
      8.997486,
      0,
      1,
      NULL,
      NULL,
      0.340062,
      NULL,
      0,
      1.730622,
      3.867574,
      0,
      0,
      0,
      NULL,
      0.329774,
      0.733582,
      0.643738,
      0.466783,
      1,
      0,
      1.614812,
      1,
      NULL,
      7,
      0.425232,
      1.879910,
      7.620467,
      0,
      4,
      0,
      5,
      NULL,
      NULL,
      NULL,
      0.207957,
      0,
      0.997651,
      NULL,
      2,
      0.474411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808100,
      0,
      2,
      0,
      1,
      1.373920,
      0.916846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992011,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958901,
      1,
      0,
      NULL,
      NULL,
      0,
      1.445847,
      NULL,
      NULL,
      NULL,
      0,
      0.841249,
      0.133254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      2.136068,
      0,
      0.859730,
      0,
      0,
      0.490096,
      0.862336,
      NULL,
      NULL,
      1,
      1,
      0.979765,
      1.668292,
      0,
      0.624150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.791589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      '01242',
      '13232',
      '12431',
      0.030137,
      '',
      NULL,
      '',
      0.999629,
      '2121',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


