set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '3332321',
      79.110823,
      3,
      1,
      NULL,
      '303342',
      2,
      ' 1- 6-1994',
      3.040465,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.955154,
      1,
      1,
      0,
      2.981836,
      0,
      1.090462,
      1,
      9,
      NULL,
      0.313222,
      8.337600,
      NULL,
      2,
      6.467354,
      NULL,
      2,
      5,
      0,
      5.689074,
      9.853356,
      0,
      NULL,
      1,
      5,
      0,
      NULL,
      NULL,
      1.532379,
      NULL,
      NULL,
      2,
      NULL,
      2.070084,
      1,
      1,
      NULL,
      2,
      2,
      2,
      1,
      3,
      3,
      NULL,
      0.382181,
      0.156835,
      1.740161,
      2.427922,
      2,
      1.231602,
      10.032873,
      3,
      NULL,
      9.812171,
      1,
      1,
      0,
      1.025080,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.475376,
      0.652263,
      3.083419,
      7,
      6,
      1.404777,
      1,
      1.590322,
      1,
      3.054340,
      0,
      3,
      7.084031,
      0,
      NULL,
      NULL,
      0.143562,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.389766,
      NULL,
      0.723687,
      1,
      0,
      1.761019,
      NULL,
      0,
      1,
      1.430864,
      0,
      0,
      2.157226,
      NULL,
      2,
      4,
      NULL,
      3.727774,
      5,
      NULL,
      3.550950,
      5.616326,
      5.092485,
      1,
      4.430339,
      3.813427,
      0.289213,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.467066,
      1,
      1,
      NULL,
      1.362279,
      0.779635,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649713,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825175,
      0.173918,
      NULL,
      NULL,
      0,
      3,
      1.499660,
      NULL,
      NULL,
      0.542521,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.982763,
      NULL,
      1.508869,
      3.627299,
      1,
      1,
      1.662105,
      3.264023,
      0.650509,
      0,
      0.705049,
      1,
      1,
      1,
      0.290142,
      1.401406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.619312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.451437,
      1.050530,
      1.351801,
      0,
      0,
      '30001',
      '33444',
      '04111',
      1.584976,
      '',
      '',
      '',
      3.681784,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


