set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      '40',
      20,
      6.639174,
      '3240213',
      10.869052,
      2,
      0.643297,
      2,
      '241214',
      4,
      ' 8-12-1999',
      NULL,
      15.300099,
      0.262970,
      NULL,
      0,
      0.633645,
      0,
      NULL,
      0,
      NULL,
      0.405696,
      NULL,
      1.612987,
      NULL,
      1,
      1.804601,
      NULL,
      5.114957,
      3,
      6,
      1,
      NULL,
      1.707007,
      0,
      0,
      NULL,
      7.062798,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.590887,
      3,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      2.283024,
      1,
      0.485392,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      0.889736,
      1,
      1.294332,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.268284,
      NULL,
      NULL,
      1.896450,
      NULL,
      NULL,
      2,
      2,
      1.356343,
      1.065718,
      NULL,
      1,
      1.647644,
      1.827973,
      1.139546,
      0,
      1,
      1.395916,
      NULL,
      0,
      1,
      0.341814,
      1.009678,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515940,
      1.990698,
      4.578145,
      1.757492,
      5,
      1.161219,
      1.817443,
      NULL,
      0,
      1.407018,
      0,
      1.094466,
      0.938580,
      NULL,
      5.699208,
      6,
      7,
      3,
      5.571638,
      2.626982,
      9.654049,
      NULL,
      1.536874,
      0,
      1.228460,
      1,
      0.549150,
      0.481510,
      1,
      1,
      1.648125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970555,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.339326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321261,
      1,
      0.334352,
      3.770154,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.936467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.483380,
      1.073469,
      0.138075,
      2,
      0,
      NULL,
      1,
      1.908970,
      1.843930,
      1.495033,
      1.962766,
      1.824529,
      0,
      1.670358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '40432',
      '11401',
      NULL,
      1,
      '',
      NULL,
      '',
      NULL,
      '0043',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


