set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      '02',
      19,
      36.234721,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '204002',
      5,
      ' 8- 5-2002',
      37.097995,
      29.538665,
      NULL,
      NULL,
      1,
      0,
      1.233902,
      0,
      0.554520,
      0.566523,
      NULL,
      NULL,
      1,
      NULL,
      5.628230,
      NULL,
      1.468086,
      NULL,
      NULL,
      0.958064,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      7,
      0,
      4.199988,
      NULL,
      NULL,
      0.189903,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.312323,
      0.527402,
      0.423316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.223888,
      1.335458,
      1,
      0.752937,
      1.969929,
      0.317645,
      0,
      1,
      0.755269,
      1.991910,
      0.521726,
      1.554164,
      1,
      1.809419,
      0.692263,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.093662,
      NULL,
      1.845071,
      3,
      0,
      0.687633,
      1.670778,
      1.720911,
      0,
      2,
      0,
      5.140071,
      0.617614,
      8,
      7,
      3.366822,
      7,
      7,
      2,
      4,
      9,
      3,
      0,
      1,
      1.661082,
      0.946443,
      0,
      1,
      1,
      0.601782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0.655126,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608257,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.744316,
      0,
      NULL,
      NULL,
      NULL,
      2.732387,
      0,
      NULL,
      0.042829,
      0,
      NULL,
      NULL,
      1.938418,
      NULL,
      NULL,
      0.671312,
      4.398171,
      0.907790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800810,
      0,
      0.776524,
      1,
      NULL,
      1,
      0.141729,
      1,
      1.564827,
      2,
      3.027942,
      0.445531,
      1,
      0.057997,
      0,
      1,
      1.274803,
      0,
      0.662622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      '12113',
      '11343',
      '13221',
      1.427571,
      '',
      '',
      NULL,
      1.284882,
      '4011',
      '',
      NULL,
      4,
      NULL,
      0.533401,
      0.371106,
      NULL,
      3,
      NULL,
      NULL,
      2);
commit;
end;
/


