set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      '01121041',
      9,
      45,
      '1304130',
      236.130404,
      1,
      0.801569,
      3,
      '423433',
      3,
      ' 3- 5-2002',
      29,
      15,
      NULL,
      NULL,
      NULL,
      2.196914,
      0,
      1.264151,
      1.726122,
      NULL,
      1.908375,
      1,
      1.488943,
      0.131059,
      5.511814,
      1.753003,
      0.935387,
      2.856016,
      2.850249,
      1,
      NULL,
      1.941977,
      4.193993,
      2,
      1,
      0.267018,
      NULL,
      0,
      1,
      NULL,
      2.604905,
      1.692401,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.320296,
      0.466315,
      1,
      3.757550,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.471499,
      0.758220,
      1.255452,
      3,
      1.520587,
      0.685301,
      3.222733,
      2.456266,
      2.237236,
      0.803765,
      0,
      1.790802,
      5,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.286478,
      0.649847,
      0.371278,
      0,
      1,
      0,
      1,
      0.788490,
      0,
      0.867868,
      NULL,
      1.567397,
      1,
      NULL,
      1.039052,
      1,
      NULL,
      1.493203,
      1.903459,
      NULL,
      1.094810,
      0,
      0,
      0,
      1.216775,
      0,
      5,
      0,
      3,
      0,
      0,
      0.614255,
      1.492551,
      1.018389,
      0,
      0.909289,
      5.490816,
      NULL,
      2.907826,
      8,
      0.313903,
      5.028781,
      6.130331,
      6,
      3,
      3,
      4.106623,
      5,
      3.773073,
      0,
      1.650053,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.127884,
      0.855477,
      1,
      0,
      NULL,
      1,
      0.673622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.757873,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.330744,
      3,
      1.471811,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.615937,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.018436,
      NULL,
      1.311250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.799646,
      NULL,
      1,
      0.018153,
      0,
      3,
      3,
      2,
      NULL,
      0.310318,
      1,
      1.214768,
      1.255116,
      1,
      0.889887,
      0.588767,
      NULL,
      NULL,
      1,
      0.627957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6,
      '24113',
      '22304',
      '03223',
      0.594149,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2.046722,
      2,
      0.718153,
      NULL,
      2,
      3,
      0,
      3,
      0);
commit;
end;
/


