set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '003',
      '12014114',
      35.669457,
      14.058574,
      '3302442',
      NULL,
      NULL,
      1.181402,
      0,
      '432401',
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.490000,
      0.580351,
      0,
      1.668904,
      NULL,
      0,
      3.511756,
      0,
      1,
      1,
      NULL,
      1.387634,
      1.445619,
      4,
      1,
      2.763561,
      7.261644,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.353482,
      1,
      0.324382,
      1,
      NULL,
      NULL,
      0.706423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.190537,
      0.303658,
      1,
      0.139713,
      3,
      0,
      0.712039,
      0.983828,
      NULL,
      0,
      NULL,
      NULL,
      1.073414,
      0.038869,
      1.792168,
      NULL,
      2.344958,
      0,
      3,
      0,
      0,
      2,
      0.733414,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.044673,
      1.856694,
      1.632861,
      0,
      0,
      0.567376,
      0.857118,
      0,
      NULL,
      NULL,
      0,
      1.552055,
      1,
      0.238027,
      0.451816,
      0.953244,
      0.136817,
      0,
      NULL,
      1.384312,
      0,
      0,
      1,
      1.413863,
      0.183331,
      1.636623,
      0,
      0.659576,
      NULL,
      NULL,
      0.958786,
      1.686460,
      1.789999,
      0,
      NULL,
      0,
      5,
      1.419097,
      1.908151,
      NULL,
      NULL,
      NULL,
      7.656890,
      5,
      1,
      NULL,
      3,
      NULL,
      0.404073,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.966933,
      0,
      0,
      NULL,
      NULL,
      1,
      0.257605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.581131,
      0.049376,
      1,
      NULL,
      NULL,
      NULL,
      0.698699,
      NULL,
      1.272356,
      NULL,
      1.711837,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.840864,
      1.533366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.399113,
      0.240719,
      3.314336,
      2,
      1,
      0.750761,
      NULL,
      3,
      1.938604,
      3.658297,
      0,
      0,
      1,
      1.411907,
      0,
      NULL,
      0.461006,
      NULL,
      0.554939,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.376675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571906,
      1.778218,
      NULL,
      0.553334,
      1,
      1,
      2,
      4,
      NULL,
      '10312',
      '03102',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      2.476697,
      2.946186,
      3,
      NULL,
      NULL,
      0.402349,
      3.281003,
      3.716699,
      1.695550);
commit;
end;
/


