set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '414',
      '33103324',
      32.967469,
      NULL,
      '3101121',
      42.876974,
      2,
      3,
      2,
      '441432',
      5.193626,
      ' 0-10-1990',
      17,
      37,
      0.014808,
      NULL,
      1.977675,
      NULL,
      0.808723,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      0.805897,
      0,
      NULL,
      1,
      5,
      4.682921,
      2.613794,
      NULL,
      0.211797,
      1.904730,
      NULL,
      2,
      0.665484,
      0,
      1,
      2.651584,
      3.789099,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      1.063066,
      NULL,
      0,
      0.697724,
      1,
      NULL,
      0.240286,
      1.815340,
      NULL,
      2,
      2.069527,
      3.007743,
      NULL,
      1.725718,
      0,
      NULL,
      1,
      1.441718,
      1,
      NULL,
      9.264153,
      3,
      1,
      0,
      2,
      0.926140,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.925363,
      0.293019,
      NULL,
      NULL,
      1.222663,
      4.531021,
      0,
      NULL,
      4,
      3.134880,
      NULL,
      5,
      1.070721,
      0,
      NULL,
      0.752485,
      0.408438,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0.641009,
      NULL,
      NULL,
      0.356394,
      1.210923,
      5.264283,
      1.349824,
      1,
      0,
      2.077701,
      0.508242,
      6.564757,
      2,
      1.029247,
      2.046307,
      NULL,
      0.740928,
      1.723339,
      0,
      0.573163,
      0,
      3,
      NULL,
      1,
      1,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.195803,
      0,
      1,
      NULL,
      NULL,
      1.969277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.724474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.206723,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      0,
      1,
      2,
      0.260462,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268345,
      2.706362,
      0.221762,
      2,
      1.973266,
      3,
      2.241646,
      NULL,
      0,
      3.217891,
      0,
      0,
      1,
      NULL,
      2,
      0.466808,
      0,
      NULL,
      NULL,
      1.608352,
      1.606887,
      0,
      0.023270,
      0.314258,
      0.074308,
      0,
      1,
      2,
      1.712897,
      0,
      1.717869,
      0,
      1.243168,
      0,
      NULL,
      1,
      0.155037,
      0,
      0.582392,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '42423',
      '33013',
      '01132',
      0.228199,
      '',
      NULL,
      '',
      0.997089,
      NULL,
      '',
      '',
      3,
      3,
      2.447060,
      3.395327,
      2,
      3.864750,
      2.427850,
      0.227573,
      1);
commit;
end;
/


