set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      '34103243',
      NULL,
      60.714887,
      '3314132',
      176,
      5,
      1.663284,
      1,
      '012024',
      3.458296,
      '11-19-1984',
      NULL,
      5.101419,
      1.132372,
      NULL,
      0,
      NULL,
      1.651232,
      0,
      1,
      NULL,
      0.490876,
      0,
      1.044734,
      NULL,
      NULL,
      0,
      1,
      5.969091,
      NULL,
      NULL,
      1,
      1,
      1.274308,
      10,
      1.961357,
      1,
      6,
      0,
      NULL,
      0.684370,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.670433,
      2.667603,
      NULL,
      NULL,
      0,
      NULL,
      2.467530,
      1,
      2.084137,
      1,
      1,
      3,
      1.577076,
      2.311682,
      3,
      1,
      3,
      1,
      0,
      0,
      1,
      5.800827,
      7.163488,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.202371,
      0.968612,
      1,
      0.015923,
      1.601250,
      NULL,
      1,
      1,
      1.936316,
      0,
      1.824116,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      1.539000,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0.085045,
      0,
      1.132397,
      1.099466,
      1,
      2.421613,
      5,
      NULL,
      9,
      5,
      2,
      7,
      6.108722,
      6.657620,
      3.525932,
      1,
      0.808308,
      NULL,
      1,
      1.806039,
      0.903593,
      0.581810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.253769,
      1,
      1,
      NULL,
      NULL,
      1.712471,
      1.466130,
      1.576114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065796,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.470595,
      1.554196,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.593823,
      0.754560,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.754725,
      3,
      2,
      NULL,
      0,
      2,
      3.329668,
      NULL,
      3.120407,
      0,
      1.598737,
      1.441883,
      1.751028,
      0.764828,
      0,
      1.283485,
      0.731035,
      1.756868,
      3,
      1.824962,
      NULL,
      0,
      0.744119,
      NULL,
      1.013300,
      2,
      1,
      0,
      0.868247,
      1.526654,
      0,
      0,
      NULL,
      1.302505,
      1,
      NULL,
      0.813301,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.529185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.935415,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214306,
      NULL,
      0.883066,
      NULL,
      1.486599,
      1,
      0,
      0,
      NULL,
      '21042',
      '44424',
      '00032',
      1,
      '',
      '',
      '',
      1.977753,
      '',
      '',
      NULL,
      5,
      3.268727,
      3.021484,
      NULL,
      2.639153,
      2.224578,
      2.405040,
      2,
      NULL);
commit;
end;
/


