set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '14213332',
      58,
      NULL,
      NULL,
      NULL,
      6,
      3.078422,
      2,
      NULL,
      4,
      ' 2-22-2002',
      NULL,
      17,
      1,
      NULL,
      0.655255,
      NULL,
      1.393116,
      0,
      1.968890,
      NULL,
      2.042464,
      0.748115,
      0,
      0.308985,
      8,
      1.404056,
      1,
      9,
      9,
      5,
      9.828173,
      1,
      6.592484,
      3.790362,
      10,
      0.186045,
      3,
      1,
      2.447859,
      2.824029,
      5.671015,
      1,
      NULL,
      NULL,
      0.090361,
      NULL,
      NULL,
      8.125600,
      0.894555,
      0,
      3.495846,
      0.428108,
      NULL,
      0,
      2.349536,
      0.219722,
      NULL,
      0,
      1.923797,
      3,
      1,
      1.781038,
      NULL,
      1.487527,
      0,
      1,
      6,
      9.551489,
      NULL,
      4.354564,
      0,
      1,
      2.184730,
      1.935974,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      4.849533,
      1,
      1,
      3.276709,
      NULL,
      1,
      0,
      4.018767,
      5.336663,
      NULL,
      NULL,
      4,
      1.186731,
      0.877303,
      1,
      1,
      1.747911,
      NULL,
      1.866421,
      0,
      NULL,
      1,
      1,
      0,
      0.086910,
      NULL,
      5,
      1,
      1.410436,
      NULL,
      1.617746,
      NULL,
      3,
      0.932427,
      4.871196,
      NULL,
      NULL,
      NULL,
      5,
      6,
      NULL,
      5.196475,
      2.662257,
      1.436109,
      NULL,
      2.687275,
      2.012766,
      0.526466,
      NULL,
      NULL,
      1.925910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.848827,
      0.609848,
      1.109826,
      2,
      4.116251,
      NULL,
      1.271894,
      0,
      NULL,
      NULL,
      1.698108,
      4,
      1.617134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.815837,
      3.195345,
      2.103845,
      2,
      NULL,
      1,
      2.418218,
      NULL,
      NULL,
      1.800377,
      0.214934,
      1,
      NULL,
      NULL,
      0,
      2.424233,
      1.541053,
      1,
      1,
      1.167290,
      1.049024,
      0.774471,
      1.362163,
      NULL,
      1.497558,
      1.628105,
      1.678930,
      1.993781,
      NULL,
      0,
      1,
      1.425815,
      1,
      0,
      0.617497,
      3.388414,
      NULL,
      NULL,
      0.488890,
      0.988484,
      0.896490,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356402,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807466,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549977,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.209090,
      NULL,
      NULL,
      '30324',
      '30104',
      NULL,
      0.510304,
      '',
      '',
      '',
      0.047946,
      '',
      NULL,
      '',
      1.868933,
      1,
      0,
      3.439143,
      3.051447,
      1,
      0.264236,
      1.696633,
      1);
commit;
end;
/


