set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '113',
      '02112424',
      23,
      77.381146,
      '3400011',
      31,
      3,
      2,
      NULL,
      '042412',
      4,
      ' 5-18-1991',
      14.936699,
      NULL,
      1,
      NULL,
      1.836331,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.425582,
      0.198336,
      2,
      1.483459,
      1.175387,
      7.141160,
      7.111730,
      6,
      4,
      NULL,
      4,
      8,
      6,
      0,
      8.894231,
      1,
      3.057790,
      NULL,
      5.271608,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971761,
      1.332837,
      1.962292,
      0,
      1,
      NULL,
      3.752512,
      0.811074,
      NULL,
      0,
      3.459891,
      2,
      0.180551,
      0,
      1,
      1,
      0.704034,
      3,
      8.240509,
      3,
      0,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.101112,
      1,
      2,
      3,
      5.754038,
      0,
      0,
      NULL,
      0.238789,
      1,
      4.615248,
      3,
      1.339074,
      0,
      0,
      1,
      0.733497,
      0,
      0,
      NULL,
      1.822114,
      1.218127,
      0.082860,
      NULL,
      0.865549,
      0,
      0.649756,
      1.667578,
      2,
      1.877062,
      2.680869,
      4.875148,
      NULL,
      NULL,
      NULL,
      0,
      6.771930,
      3,
      NULL,
      5.907380,
      1,
      1.925308,
      6.240462,
      4,
      NULL,
      0.365378,
      1.567704,
      3,
      2,
      0,
      0.868158,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.475228,
      0,
      NULL,
      0.652958,
      1,
      1,
      1.893929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.958007,
      0,
      0,
      NULL,
      1.261872,
      NULL,
      5,
      0.506140,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.354367,
      0,
      1,
      0.435409,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.024771,
      0,
      1.345599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      0,
      3,
      2.909464,
      1,
      1.163223,
      NULL,
      0,
      1.567232,
      NULL,
      1,
      0.191040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '11202',
      '02412',
      '32031',
      0.623805,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      2,
      0,
      0,
      NULL,
      NULL,
      4,
      0,
      2.090592,
      1.230976);
commit;
end;
/


