set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3343',
      '31224420',
      15,
      24,
      '3131023',
      23,
      3,
      NULL,
      1,
      '314043',
      1,
      NULL,
      10.710800,
      27.394045,
      0.766030,
      NULL,
      0,
      3,
      1,
      1,
      1.534992,
      1.234095,
      0.213709,
      0.589947,
      1,
      1.655436,
      6,
      1.073369,
      1.274502,
      0.904365,
      1,
      2,
      5.596415,
      1.822179,
      1,
      10,
      5,
      6,
      NULL,
      NULL,
      4.054622,
      1,
      1,
      0,
      NULL,
      NULL,
      0.900684,
      NULL,
      NULL,
      2.287671,
      1,
      0,
      0.301042,
      0.792846,
      NULL,
      NULL,
      NULL,
      1.917813,
      0,
      NULL,
      0.595293,
      NULL,
      2.351874,
      0.457397,
      1,
      0.608525,
      1.661654,
      0,
      4.420090,
      3.248155,
      3,
      2.823666,
      NULL,
      NULL,
      2.763820,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      2.187490,
      2.364785,
      1,
      0,
      4.721112,
      1,
      1.218093,
      1.969304,
      0.965240,
      0,
      NULL,
      1,
      1,
      0.053601,
      NULL,
      1,
      1.090790,
      1.695757,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.222379,
      0,
      NULL,
      0.810476,
      NULL,
      8,
      NULL,
      6.218117,
      2,
      NULL,
      7.188465,
      6,
      3.018166,
      2.314308,
      1,
      0.981452,
      1.171418,
      1.067628,
      1.792433,
      NULL,
      1.764010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863109,
      1,
      1,
      0,
      1.408055,
      1.200092,
      0.437251,
      1.959920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.975918,
      0,
      NULL,
      NULL,
      NULL,
      5.561288,
      1.702517,
      0,
      0.230728,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515653,
      0.466510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.253633,
      1.169298,
      1.408538,
      NULL,
      0,
      3.871125,
      0.503190,
      0,
      3.113861,
      NULL,
      0.313709,
      1.336302,
      0,
      NULL,
      0.017750,
      NULL,
      1.317810,
      1.081876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      '13443',
      '40132',
      '11400',
      1.835710,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      4,
      0,
      1.475746,
      1,
      NULL,
      5.430292,
      2,
      NULL,
      1);
commit;
end;
/


