set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1410',
      '03102443',
      48,
      71.415255,
      '4430212',
      299.935842,
      2,
      2.825833,
      1,
      '432014',
      4.706927,
      ' 1-11-1984',
      4.978591,
      NULL,
      0.835166,
      NULL,
      0.642417,
      1,
      0.114494,
      1,
      NULL,
      0.156955,
      2.015302,
      1.306877,
      0,
      1.107388,
      NULL,
      NULL,
      0,
      9,
      6.794743,
      4,
      6.824088,
      0.802389,
      5.006095,
      6,
      10.008149,
      10.062888,
      7,
      NULL,
      3,
      3,
      1.977593,
      0.871188,
      NULL,
      NULL,
      1.693804,
      NULL,
      NULL,
      1.782371,
      4.512392,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.649152,
      1.987613,
      2.363593,
      3,
      NULL,
      0,
      0,
      2.470000,
      1,
      3.774626,
      1.548602,
      NULL,
      0,
      1.965538,
      5.579891,
      8.146420,
      NULL,
      1,
      2.290864,
      1.443927,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      3.400542,
      1,
      NULL,
      3,
      1.010365,
      1,
      1.748413,
      0.136365,
      NULL,
      5,
      0.358932,
      2.678193,
      0.378315,
      1.944814,
      0.180038,
      1.040244,
      1,
      NULL,
      0,
      1.954032,
      NULL,
      0.624686,
      0,
      NULL,
      0.424576,
      1.960957,
      NULL,
      0.422432,
      0.864959,
      1,
      NULL,
      1,
      1.237364,
      NULL,
      2.702171,
      0.691912,
      4.160867,
      6.900350,
      0,
      5,
      7,
      NULL,
      8.213238,
      0.644426,
      NULL,
      4,
      2,
      1.005409,
      0,
      0.026065,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719075,
      1,
      0,
      0.081367,
      1.188316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309691,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.665642,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.111782,
      0.790904,
      0.776133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.058160,
      2,
      1.548898,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2,
      0,
      1.197779,
      0,
      1.276974,
      1.341759,
      0.744485,
      1.333263,
      3,
      1.002679,
      3,
      1,
      0.861118,
      NULL,
      1,
      NULL,
      3,
      1,
      3.592696,
      3.385964,
      0,
      0.823203,
      1.874299,
      1,
      0.514186,
      1.013197,
      1,
      1.639627,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.189360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.244760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152154,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144826,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      '01233',
      '02424',
      NULL,
      0,
      '',
      '',
      '',
      0.682798,
      '',
      '',
      '',
      3.319359,
      2,
      1.585484,
      3,
      0.516821,
      1.089175,
      1.006535,
      NULL,
      2.768856);
commit;
end;
/


