set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0343',
      '13031141',
      NULL,
      4,
      '1112224',
      375.904338,
      5,
      1,
      NULL,
      '010003',
      5.214260,
      '11-27-1994',
      6,
      9.509930,
      NULL,
      NULL,
      1.356138,
      1.907259,
      1.119083,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      8.827341,
      5,
      5.640394,
      5,
      0,
      1.632919,
      3,
      0.146001,
      1.363251,
      2.515398,
      NULL,
      NULL,
      0.531865,
      3.484347,
      1,
      NULL,
      NULL,
      1.666535,
      NULL,
      NULL,
      3,
      2,
      0,
      1.745726,
      1.629001,
      0.709689,
      NULL,
      2,
      1.139177,
      2.120945,
      0.885200,
      2,
      2.391062,
      1,
      1,
      1,
      3,
      0.433871,
      NULL,
      6.710310,
      6,
      9,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      2.624931,
      4,
      1,
      1,
      NULL,
      1.141890,
      4.430868,
      2.978646,
      0,
      1.900771,
      0,
      NULL,
      NULL,
      0.642452,
      0.094514,
      NULL,
      0,
      0,
      1,
      0.364540,
      0,
      1,
      0.391503,
      1.069444,
      2,
      NULL,
      1,
      5.415967,
      1.629805,
      0,
      3,
      0,
      7.475437,
      6,
      4,
      NULL,
      2.509485,
      5.036799,
      2,
      1,
      NULL,
      5,
      1,
      5.776211,
      3,
      0.171029,
      0.868831,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.842885,
      1,
      1.990060,
      1.673069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      2.384268,
      1,
      NULL,
      0.741480,
      NULL,
      NULL,
      NULL,
      0,
      1.291874,
      1.327139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      3,
      1.053633,
      1,
      NULL,
      3.641954,
      NULL,
      0.079473,
      0,
      NULL,
      NULL,
      2.042151,
      3,
      0,
      1,
      1,
      2.290641,
      1,
      1.948836,
      0.318488,
      1,
      0.902631,
      NULL,
      2.760784,
      3.897235,
      NULL,
      0.963796,
      1,
      NULL,
      1,
      1,
      0.450166,
      0.284470,
      0,
      1.028759,
      NULL,
      NULL,
      NULL,
      1.312803,
      2,
      1.495327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351272,
      NULL,
      1.573852,
      NULL,
      0.988689,
      NULL,
      1.942597,
      1,
      7.662254,
      '21114',
      '40333',
      '43112',
      1.884360,
      '',
      '',
      '',
      1.654163,
      NULL,
      '',
      '',
      5.255717,
      3,
      0,
      NULL,
      3,
      0,
      0.604755,
      NULL,
      NULL);
commit;
end;
/


