set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      0,
      45.804576,
      NULL,
      64.674450,
      NULL,
      3,
      0,
      '031030',
      6.148047,
      '10- 3-1992',
      NULL,
      4,
      1.097211,
      NULL,
      1,
      2,
      0.001016,
      0,
      1.150987,
      NULL,
      3.546252,
      0,
      1.720315,
      NULL,
      4.171829,
      0,
      1,
      9.383167,
      5,
      3.772436,
      9,
      1.747887,
      8,
      0.904984,
      4.744150,
      1.797382,
      8.839387,
      0,
      0,
      3.169134,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.114354,
      0,
      3.809485,
      1,
      1.439001,
      0,
      1.588665,
      NULL,
      0,
      0,
      3,
      0.770400,
      3,
      1.780920,
      0,
      NULL,
      0,
      0,
      2,
      6.375571,
      NULL,
      6.819048,
      0,
      2,
      1.800101,
      1.538596,
      NULL,
      NULL,
      1.413128,
      NULL,
      NULL,
      0.828635,
      NULL,
      1.650013,
      1,
      2.205252,
      1,
      1,
      0,
      1,
      1.183044,
      0.387901,
      0.998512,
      1.474059,
      NULL,
      1.297321,
      NULL,
      NULL,
      NULL,
      0.071559,
      NULL,
      1.860325,
      0,
      0,
      1,
      1,
      1.503148,
      1,
      1.137108,
      2,
      NULL,
      1,
      1.263183,
      5.142022,
      0.990686,
      0.149732,
      0,
      4,
      0,
      NULL,
      1,
      0,
      1,
      0.246099,
      4.937581,
      3,
      2,
      3,
      7.206602,
      1,
      1.869553,
      0.679707,
      2.286626,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.493272,
      1.509059,
      NULL,
      0,
      1,
      1.744885,
      NULL,
      0.965209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.911753,
      0.257945,
      NULL,
      NULL,
      NULL,
      0.987052,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.090484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.599014,
      2.675481,
      2.348689,
      NULL,
      1,
      NULL,
      2,
      0.654077,
      1.255644,
      3,
      1.040897,
      1,
      0,
      0.037063,
      NULL,
      2,
      0,
      1,
      1,
      3.269331,
      NULL,
      1,
      0.818288,
      0.107804,
      NULL,
      2.903827,
      2,
      NULL,
      0.522070,
      0.192099,
      1,
      1,
      NULL,
      0.727139,
      1.352848,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.149633,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380622,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.347877,
      1.423707,
      0,
      2,
      4.000579,
      '24034',
      '12030',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      NULL,
      1.392925,
      3.696304,
      1.783659,
      0.359056,
      3,
      2.251504,
      0,
      NULL);
commit;
end;
/


