set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8318863';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0030',
      '30412130',
      46,
      61.889528,
      '2302200',
      238.402629,
      6,
      1.445574,
      3,
      '223242',
      NULL,
      NULL,
      8,
      13.884366,
      0,
      NULL,
      0.595321,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      4,
      0,
      0.814338,
      9.297774,
      3.831386,
      0.713301,
      1,
      1,
      0,
      NULL,
      11.885693,
      NULL,
      NULL,
      1,
      2.634965,
      2.079367,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.567958,
      6.521674,
      1.370647,
      3,
      0,
      0.470661,
      0,
      2,
      0.516404,
      1.003125,
      3,
      3,
      2.828356,
      0.959484,
      0,
      0.904652,
      2.295313,
      0,
      1.042221,
      5.677571,
      4.584535,
      NULL,
      4.637532,
      1,
      0,
      0.113935,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.693687,
      5.415440,
      2.527346,
      0,
      5.687803,
      4,
      2.219346,
      0.871430,
      1,
      1.213772,
      0.198192,
      0,
      1.382183,
      0,
      1.080316,
      1.049947,
      0.527045,
      1.950818,
      1,
      NULL,
      0.589761,
      0.856688,
      1,
      NULL,
      1,
      0,
      NULL,
      1.835657,
      5.011937,
      1.101378,
      0,
      0,
      NULL,
      1,
      2,
      0,
      NULL,
      7,
      NULL,
      5,
      5.574748,
      0.613200,
      2.610038,
      5,
      NULL,
      3.975325,
      3,
      4.026407,
      3.084351,
      0.124857,
      NULL,
      1.816199,
      1.283063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.369018,
      1,
      NULL,
      1,
      0,
      1.231838,
      3.234303,
      1.390801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847467,
      1,
      NULL,
      NULL,
      NULL,
      2.098844,
      1,
      0,
      1,
      NULL,
      2,
      0.969999,
      NULL,
      NULL,
      NULL,
      1.002803,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903935,
      0.744252,
      0.617898,
      0.007757,
      3,
      1,
      NULL,
      NULL,
      1.134424,
      NULL,
      1,
      1.976552,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      1.943460,
      1,
      NULL,
      NULL,
      0.487565,
      NULL,
      NULL,
      2.787120,
      NULL,
      1.643917,
      0.184627,
      1.764439,
      0.710422,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1.869653,
      1,
      1,
      2.894534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.211206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.081351,
      NULL,
      NULL,
      NULL,
      NULL,
      1.909551,
      NULL,
      NULL,
      NULL,
      NULL,
      3.449100,
      0,
      NULL,
      NULL,
      0.359256,
      1.095768,
      0.419292,
      1,
      3,
      '11440',
      '14001',
      '14013',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.568796,
      1.032304,
      0.150801,
      2.113524,
      3,
      5,
      0.062646,
      1.258656,
      2.031393);
commit;
end;
/


