set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      1.920603,
      ' 9-25-1975',
      25.357838,
      NULL,
      0,
      NULL,
      0.334155,
      3,
      0,
      1,
      0.884633,
      1.400521,
      0,
      0.989281,
      1,
      1.507250,
      NULL,
      1,
      0.076837,
      3.306830,
      1.949795,
      0.748092,
      3.033488,
      0.395300,
      1,
      0,
      0,
      1.437324,
      NULL,
      1,
      4,
      NULL,
      0,
      0.965565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.671830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680149,
      0.405056,
      0,
      0.213433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065183,
      NULL,
      5.818230,
      NULL,
      4.873458,
      0.439892,
      4,
      0.739473,
      2.340127,
      1.392800,
      NULL,
      1,
      0.639458,
      NULL,
      1.408098,
      1,
      NULL,
      0.424618,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.393457,
      1,
      0.337575,
      2,
      4,
      3.621558,
      0.274720,
      0.190453,
      NULL,
      NULL,
      3.059968,
      0.549454,
      1.340273,
      5.811453,
      1.494299,
      7,
      4.057320,
      11,
      3,
      11.484078,
      5.775551,
      1,
      5.520471,
      0.943716,
      0.734182,
      NULL,
      3.665724,
      0.352681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.217697,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.004121,
      3.289873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.237480,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      3,
      1,
      4.765412,
      1,
      1,
      0.363329,
      0.387551,
      NULL,
      5.975901,
      0,
      0,
      3.656281,
      1.975514,
      0,
      0.795280,
      NULL,
      NULL,
      NULL,
      1.444101,
      1.649766,
      1.818756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.435280,
      2.091229,
      1.737477,
      NULL,
      1.235556,
      0.918645,
      NULL,
      1,
      2.887350,
      1.182330,
      1.872853,
      NULL,
      1.627300,
      1,
      0.736864,
      0.415145,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.086703,
      NULL,
      '',
      NULL,
      2.640288,
      '13440',
      '',
      NULL,
      1.665408,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


