set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9106629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      NULL,
      '1221234',
      13.734973,
      4,
      0.546063,
      0,
      NULL,
      2,
      ' 1- 5-1999',
      27.632745,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.475089,
      NULL,
      0,
      2.364751,
      3.669953,
      0,
      NULL,
      0,
      1,
      1.559610,
      NULL,
      0.430966,
      3,
      0.354827,
      0.553165,
      0,
      1.259991,
      NULL,
      NULL,
      1.728509,
      1,
      1,
      2,
      NULL,
      0.213647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010945,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311812,
      4,
      3,
      2.827889,
      NULL,
      1.442583,
      5.501362,
      1.840575,
      3,
      1.404864,
      0,
      2,
      1,
      3.217456,
      0,
      1,
      1.858982,
      0.109383,
      0,
      NULL,
      NULL,
      NULL,
      4.749532,
      1.586924,
      5.422249,
      1,
      4,
      1.247093,
      4.514719,
      0,
      1.085048,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      3,
      2.627620,
      3,
      5.989279,
      9.408972,
      6.396312,
      10.922988,
      3,
      11,
      NULL,
      1,
      0,
      1.829590,
      0,
      1,
      9,
      2.799356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624768,
      0.721416,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1.090174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.348190,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      0,
      2.280916,
      1.549682,
      4.983884,
      1,
      3.923410,
      1.791913,
      0.869881,
      NULL,
      4.478952,
      0,
      3.757335,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.295802,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217100,
      1.441282,
      NULL,
      2.394962,
      3,
      0.202393,
      NULL,
      2,
      2,
      1,
      3.378153,
      0.353085,
      0.702862,
      0.356335,
      1.823651,
      1.468396,
      0,
      0.084812,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13332',
      '',
      '',
      2.344569,
      '44320',
      NULL,
      NULL,
      0.881411,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


